% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{model-method-variables}
\alias{model-method-variables}
\alias{variables}
\title{Input and output variables of a Stan program}
\usage{
variables()
}
\value{
The \verb{$variables()} returns a list with information on input and
output variables for each of the Stan model blocks.
}
\description{
The \verb{$variables()} method of a \code{\link{CmdStanModel}} object returns
a list, each element representing a Stan model block: \code{data}, \code{parameters},
\code{transformed_parameters} and \code{generated_quantities}.

Each element contains a list of variables, with each variables represented
as a list with infromation on its scalar type (\code{real} or \code{int}) and
number of dimensions.

\verb{transformed data} is not included, as variables in that block are not
part of the model's input or output.
}
\examples{
\dontrun{
file <- file.path(cmdstan_path(), "examples/bernoulli/bernoulli.stan")

# create a `CmdStanModel` object, compiling the model is not required
mod <- cmdstan_model(file, compile = FALSE)

mod$variables()

}

}
\seealso{
Other CmdStanModel methods: 
\code{\link{model-method-check_syntax}},
\code{\link{model-method-compile}},
\code{\link{model-method-diagnose}},
\code{\link{model-method-format}},
\code{\link{model-method-generate-quantities}},
\code{\link{model-method-optimize}},
\code{\link{model-method-sample_mpi}},
\code{\link{model-method-sample}},
\code{\link{model-method-variational}}
}
\concept{CmdStanModel methods}
