% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{CmdStanMCMC}
\alias{CmdStanMCMC}
\title{CmdStanMCMC objects}
\description{
A \code{CmdStanMCMC} object is the fitted model object returned by
the \code{\link[=model-method-sample]{$sample()}} method of a \code{\link{CmdStanModel}} object.
Like \code{CmdStanModel} objects, \code{CmdStanMCMC} objects are \link[R6:R6Class]{R6}
objects.
}
\section{Methods}{
 \code{CmdStanMCMC} objects have the following associated
methods, all of which have their own (linked) documentation pages.
\subsection{Extract contents of fitted model object}{\tabular{ll}{
   \strong{Method} \tab \strong{Description} \cr
   \code{\link[=fit-method-draws]{$draws()}} \tab Return posterior draws using formats from the \pkg{posterior} package. \cr
   \code{\link[=fit-method-sampler_diagnostics]{$sampler_diagnostics()}} \tab Return sampler diagnostics as a \code{\link[posterior:draws_array]{draws_array}}. \cr
   \code{\link[=fit-method-lp]{$lp()}} \tab Return the total log probability density (\code{target}). \cr
   \code{\link[=fit-method-inv_metric]{$inv_metric()}} \tab Return the inverse metric for each chain. \cr
   \code{\link[=fit-method-init]{$init()}} \tab Return user-specified initial values. \cr
   \code{\link[=fit-method-metadata]{$metadata()}} \tab Return a list of metadata gathered from the CmdStan CSV files. \cr
   \code{\link[=fit-method-num_chains]{$num_chains()}} \tab Return the number of MCMC chains. \cr
   \code{\link[=fit-method-code]{$code()}} \tab Return Stan code as a character vector. \cr
}

}

\subsection{Summarize inferences and diagnostics}{\tabular{ll}{
   \strong{Method} \tab \strong{Description} \cr
   \code{\link[=fit-method-print]{$print()}} \tab Run \code{\link[posterior:draws_summary]{posterior::summarise_draws()}}. \cr
   \code{\link[=fit-method-summary]{$summary()}} \tab Run \code{\link[posterior:draws_summary]{posterior::summarise_draws()}}. \cr
   \code{\link[=fit-method-diagnostic_summary]{$diagnostic_summary()}} \tab Get summaries of sampler diagnostics and warning messages. \cr
   \code{\link[=fit-method-cmdstan_summary]{$cmdstan_summary()}} \tab Run and print CmdStan's \code{bin/stansummary}. \cr
   \code{\link[=fit-method-cmdstan_summary]{$cmdstan_diagnose()}} \tab Run and print CmdStan's \code{bin/diagnose}. \cr
   \code{\link[=fit-method-loo]{$loo()}} \tab Run \code{\link[loo:loo]{loo::loo.array()}} for approximate LOO-CV \cr
}

}

\subsection{Save fitted model object and temporary files}{\tabular{ll}{
   \strong{Method} \tab \strong{Description} \cr
   \code{\link[=fit-method-save_object]{$save_object()}} \tab Save fitted model object to a file. \cr
   \code{\link[=fit-method-save_output_files]{$save_output_files()}} \tab Save output CSV files to a specified location. \cr
   \code{\link[=fit-method-save_data_file]{$save_data_file()}} \tab Save JSON data file to a specified location. \cr
   \code{\link[=fit-method-save_latent_dynamics_files]{$save_latent_dynamics_files()}} \tab Save diagnostic CSV files to a specified location. \cr
}

}

\subsection{Report run times, console output, return codes}{\tabular{ll}{
   \strong{Method} \tab \strong{Description} \cr
   \code{\link[=fit-method-output]{$output()}} \tab Return the stdout and stderr of all chains or pretty print the output for a single chain. \cr
   \code{\link[=fit-method-time]{$time()}} \tab Report total and chain-specific run times. \cr
   \code{\link[=fit-method-return_codes]{$return_codes()}} \tab Return the return codes from the CmdStan runs. \cr
}

}
}

\seealso{
The CmdStanR website
(\href{https://mc-stan.org/cmdstanr/}{mc-stan.org/cmdstanr}) for online
documentation and tutorials.

The Stan and CmdStan documentation:
\itemize{
\item Stan documentation: \href{https://mc-stan.org/users/documentation/}{mc-stan.org/users/documentation}
\item CmdStan User’s Guide: \href{https://mc-stan.org/docs/cmdstan-guide/}{mc-stan.org/docs/cmdstan-guide}
}

Other fitted model objects: 
\code{\link{CmdStanDiagnose}},
\code{\link{CmdStanGQ}},
\code{\link{CmdStanMLE}},
\code{\link{CmdStanVB}}
}
\concept{fitted model objects}
