% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{CCRseqk}
\alias{CCRseqk}
\title{Sequential CCR with k clusters}
\usage{
CCRseqk(Y, X, k, nC = 1, kap = 0.1, modclass = "lm", tol = 1e-06,
  reltol = TRUE, rndcov = NULL, report = NULL, ...)
}
\arguments{
\item{Y}{vector of dependent variable Y}

\item{X}{design matrix (without intercept)}

\item{k}{number of clusters}

\item{nC}{first \code{nC-1} columns in \code{X} not to cluster}

\item{kap}{maximum number of parameters to estimate in each active sequential step,
as a fraction of the less of total number of observations n or number of covariates p.
i.e. \eqn{min(n,p)}}

\item{modclass}{a string denoting the desired the class of model. See \link{c_chmod} for details.}

\item{tol}{level of tolerance for convergence; default \code{tol=1e-6}}

\item{reltol}{a logical for relative tolerance instead of level. Defaults at TRUE}

\item{rndcov}{seed for randomising assignment of covariates to partitions; default \code{NULL}}

\item{report}{number of iterations after which to report progress; default \code{NULL}}

\item{...}{additional arguments to be passed to the model}
}
\value{
a list of objects
\itemize{
\item mobj low dimensional model object of class lm, glm, or rq (depending on \code{modclass})
\item clus cluster assignments of covariates
\item iter number of iterations
\item dev decrease in the function value at convergence
}
}
\description{
\code{CCRseqk} runs regressions with potentially more covariates than observations with
\code{k} clusters. See \code{c_chmod()} for the list of models supported.
}
\examples{
set.seed(14) #Generate data
N = 1000; (bets = rep(-2:2,4)/2); p = length(bets); X = matrix(rnorm(N*p),N,p)
Y = cbind(1,X)\%*\%matrix(c(0.5,bets),ncol = 1); nC=1
zg=CCRseqk(Y,X,k=5,nC=nC,kap=0.1,modclass="lm",tol=1e-6,reltol=TRUE,rndcov=NULL,report=8)
(del=zg$mobj$coefficients) # delta
(bets = c(del[1:nC],(del[-c(1:nC)])[zg$clus])) #construct beta
}
