% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/if_else.R
\name{cheapr_if_else}
\alias{cheapr_if_else}
\title{Cheaper version of \code{ifelse()}}
\usage{
cheapr_if_else(condition, true, false, na = false[NA_integer_])
}
\arguments{
\item{condition}{\link{logical} A condition which will be used to
evaluate the if else operation.}

\item{true}{Value(s) to replace \code{TRUE} instances.}

\item{false}{Value(s) to replace \code{FALSE} instances.}

\item{na}{Catch-all value(s) to replace all other instances,
where \code{is.na(condition)}.}
}
\value{
A vector the same length as condition,
using a common type between \code{true}, \code{false} and \code{default}.
}
\description{
Cheaper version of \code{ifelse()}
}
\seealso{
\link{case} \link{val_match}
}
