% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MinkowskiSum.R
\name{MinkowskiSum}
\alias{MinkowskiSum}
\title{Minkowski addition}
\usage{
MinkowskiSum(mesh1, mesh2)
}
\arguments{
\item{mesh1, mesh2}{two \code{cgalMesh} objects representing triangle 
meshes}
}
\value{
A \code{cgalMesh} object. The mesh it represents is not triangle 
  in general.
}
\description{
Minkowski addition of two meshes.
}
\examples{
library(cgalMeshes)
library(rgl)
# cube + icosahedron
mesh1 <- cgalMesh$new(cube3d())$triangulate()
mesh2 <- cgalMesh$new(icosahedron3d())
mesh <- MinkowskiSum(mesh1, mesh2)
# get the edges before triangulation for plotting
edges <- mesh$getEdges()
# triangulation
mesh$triangulate()
# plot
rmesh <- mesh$getMesh()
open3d(windowRect = 50 + c(0, 0, 512, 512))
view3d(20, 40, zoom = 0.85)
shade3d(rmesh, color = "turquoise")
plotEdges(
  mesh$getVertices(), edges[, c("i1", "i2")], 
  color = "darkred", tubesRadius = 0.07, spheresRadius = 0.1
)
}
