% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decision_tree-rpart.R
\name{survival_prob_pecRpart}
\alias{survival_prob_pecRpart}
\title{A wrapper for survival probabilities with pecRpart models}
\usage{
survival_prob_pecRpart(object, new_data, eval_time)
}
\arguments{
\item{object}{A parsnip \code{model_fit} object resulting from \link[parsnip:details_decision_tree_rpart]{decision_tree() with engine = "rpart"}.}

\item{new_data}{Data for prediction.}

\item{eval_time}{A vector of integers for prediction times.}
}
\value{
A tibble with a list column of nested tibbles.
}
\description{
A wrapper for survival probabilities with pecRpart models
}
\examples{
\dontshow{if (rlang::is_installed("pec")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mod <- decision_tree() \%>\% 
  set_mode("censored regression") \%>\%
    set_engine("rpart") \%>\%
    fit(Surv(time, status) ~ ., data = lung)
survival_prob_pecRpart(mod, new_data = lung[1:3, ], eval_time = 300)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
