% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculus.R
\name{lim}
\alias{lim}
\title{Limit of a function}
\usage{
lim(f, var, val, dir = NULL, doit = TRUE)
}
\arguments{
\item{f}{Function to take limit of}

\item{var}{Variable to take limit for (either string or \code{caracas_symbol})}

\item{val}{Value for \code{var} to approach}

\item{dir}{Direction from where \code{var} should approach \code{val}: \code{'+'} or \code{'-'}}

\item{doit}{Evaluate the limit immediately (or later with \code{\link[=doit]{doit()}})}
}
\description{
Limit of a function
}
\examples{
if (has_sympy()) {
  x <- symbol("x")
  lim(sin(x)/x, "x", 0)
  lim(1/x, "x", 0, dir = '+')
  lim(1/x, "x", 0, dir = '-')
}

}
\concept{calculus}
