% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{\%div\%}
\alias{\%div\%}
\title{Numerical and Symbolic Division}
\usage{
x \%div\% y
}
\arguments{
\item{x}{\code{numeric} or \code{character} array.}

\item{y}{\code{numeric} or \code{character} array.}
}
\value{
\code{array}.
}
\description{
Elementwise division of \code{numeric} or \code{character} arrays.
}
\examples{
### vector 
x <- c("a+1","b+2")
x \%div\% x

### matrix 
x <- matrix(letters[1:4], ncol = 2)
x \%div\% x

### array
x <- array(letters[1:12], dim = c(2,2,3))
y <- array(1:12, dim = c(2,2,3))
x \%div\% y 

}
\references{
Guidotti E (2022). "calculus: High-Dimensional Numerical and Symbolic Calculus in R." Journal of Statistical Software, 104(5), 1-37. \doi{10.18637/jss.v104.i05}
}
\seealso{
Other basic arithmetic: 
\code{\link{\%diff\%}()},
\code{\link{\%dot\%}()},
\code{\link{\%inner\%}()},
\code{\link{\%kronecker\%}()},
\code{\link{\%outer\%}()},
\code{\link{\%prod\%}()},
\code{\link{\%sum\%}()}
}
\concept{basic arithmetic}
