% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bvar-ssvs.R, R/print-bvharsp.R
\name{bvar_ssvs}
\alias{bvar_ssvs}
\alias{print.bvarssvs}
\alias{knit_print.bvarssvs}
\title{Fitting Bayesian VAR(p) of SSVS Prior}
\usage{
bvar_ssvs(
  y,
  p,
  num_chains = 1,
  num_iter = 1000,
  num_burn = floor(num_iter/2),
  thinning = 1,
  bayes_spec = choose_ssvs(y = y, ord = p, type = "VAR", param = c(0.1, 10), include_mean
    = include_mean, gamma_param = c(0.01, 0.01), mean_non = 0, sd_non = 0.1),
  init_spec = init_ssvs(type = "auto"),
  include_mean = TRUE,
  minnesota = FALSE,
  verbose = FALSE,
  num_thread = 1
)

\method{print}{bvarssvs}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{knit_print}{bvarssvs}(x, ...)
}
\arguments{
\item{y}{Time series data of which columns indicate the variables}

\item{p}{VAR lag}

\item{num_chains}{Number of MCMC chains}

\item{num_iter}{MCMC iteration number}

\item{num_burn}{Number of burn-in (warm-up). Half of the iteration is the default choice.}

\item{thinning}{Thinning every thinning-th iteration}

\item{bayes_spec}{A SSVS model specification by \code{\link[=set_ssvs]{set_ssvs()}}. By default, use a default semiautomatic approach \code{\link[=choose_ssvs]{choose_ssvs()}}.}

\item{init_spec}{SSVS initialization specification by \code{\link[=init_ssvs]{init_ssvs()}}. By default, use OLS for coefficient and cholesky factor while 1 for dummies.}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{minnesota}{Apply cross-variable shrinkage structure (Minnesota-way). By default, \code{FALSE}.}

\item{verbose}{Print the progress bar in the console. By default, \code{FALSE}.}

\item{num_thread}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Number of threads}

\item{x}{\code{bvarssvs} object}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
\code{bvar_ssvs} returns an object named \code{bvarssvs} \link{class}.
It is a list with the following components:

\describe{
\item{coefficients}{Posterior mean of VAR coefficients.}
\item{chol_posterior}{Posterior mean of cholesky factor matrix}
\item{covmat}{Posterior mean of covariance matrix}
\item{omega_posterior}{Posterior mean of omega}
\item{pip}{Posterior inclusion probability}
\item{param}{\link[posterior:draws_df]{posterior::draws_df} with every variable: alpha, eta, psi, omega, and gamma}
\item{param_names}{Name of every parameter.}
\item{df}{Numer of Coefficients: \code{mp + 1} or \code{mp}}
\item{p}{Lag of VAR}
\item{m}{Dimension of the data}
\item{obs}{Sample size used when training = \code{totobs} - \code{p}}
\item{totobs}{Total number of the observation}
\item{call}{Matched call}
\item{process}{Description of the model, e.g. \code{VAR_SSVS}}
\item{type}{include constant term (\code{const}) or not (\code{none})}
\item{spec}{SSVS specification defined by \code{\link[=set_ssvs]{set_ssvs()}}}
\item{init}{Initial specification defined by \code{\link[=init_ssvs]{init_ssvs()}}}
\item{chain}{The numer of chains}
\item{iter}{Total iterations}
\item{burn}{Burn-in}
\item{thin}{Thinning}
\item{group}{Indicators for group.}
\item{num_group}{Number of groups.}
\item{y0}{\eqn{Y_0}}
\item{design}{\eqn{X_0}}
\item{y}{Raw input}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This function fits BVAR(p) with stochastic search variable selection (SSVS) prior.
}
\details{
SSVS prior gives prior to parameters \eqn{\alpha = vec(A)} (VAR coefficient) and \eqn{\Sigma_e^{-1} = \Psi \Psi^T} (residual covariance).

\deqn{\alpha_j \mid \gamma_j \sim (1 - \gamma_j) N(0, \kappa_{0j}^2) + \gamma_j N(0, \kappa_{1j}^2)}
\deqn{\gamma_j \sim Bernoulli(q_j)}

and for upper triangular matrix \eqn{\Psi},

\deqn{\psi_{jj}^2 \sim Gamma(shape = a_j, rate = b_j)}
\deqn{\psi_{ij} \mid w_{ij} \sim (1 - w_{ij}) N(0, \kappa_{0,ij}^2) + w_{ij} N(0, \kappa_{1,ij}^2)}
\deqn{w_{ij} \sim Bernoulli(q_{ij})}
}
\references{
George, E. I., & McCulloch, R. E. (1993). \emph{Variable Selection via Gibbs Sampling}. Journal of the American Statistical Association, 88(423), 881-889.

George, E. I., Sun, D., & Ni, S. (2008). \emph{Bayesian stochastic search for VAR model restrictions}. Journal of Econometrics, 142(1), 553-580.

Koop, G., & Korobilis, D. (2009). \emph{Bayesian Multivariate Time Series Methods for Empirical Macroeconomics}. Foundations and Trends® in Econometrics, 3(4), 267-358.
}
