% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.recipe.R
\name{axe-train.recipe}
\alias{axe-train.recipe}
\alias{axe_call.train.recipe}
\alias{axe_ctrl.train.recipe}
\alias{axe_data.train.recipe}
\alias{axe_env.train.recipe}
\alias{axe_fitted.train.recipe}
\title{Axing a train.recipe object.}
\usage{
\method{axe_call}{train.recipe}(x, ...)

\method{axe_ctrl}{train.recipe}(x, ...)

\method{axe_data}{train.recipe}(x, ...)

\method{axe_env}{train.recipe}(x, ...)

\method{axe_fitted}{train.recipe}(x, ...)
}
\arguments{
\item{x}{A model object.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed train.recipe object.
}
\description{
train.recipe objects are slightly different from train objects
created from the \code{caret} package in that it also includes
instructions from a \code{recipe} for data pre-processing. Axing
functions specific to train.recipe are thus included as additional
steps are required to remove parts of train.recipe objects.
}
\examples{
\dontshow{if (interactive() || identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(recipes)
library(caret)
data(biomass, package = "modeldata")

data(biomass)
recipe <- biomass \%>\%
  recipe(HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur) \%>\%
  step_center(all_predictors()) \%>\%
  step_scale(all_predictors()) \%>\%
  step_spatialsign(all_predictors())

train.recipe_fit <- train(recipe, biomass,
                          method = "svmRadial",
                          metric = "RMSE")

out <- butcher(train.recipe_fit, verbose = TRUE)
\dontshow{\}) # examplesIf}
}
