% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_bsvar_sv.R
\name{specify_bsvar_sv}
\alias{specify_bsvar_sv}
\title{R6 Class representing the specification of the BSVAR model with Stochastic Volatility heteroskedasticity.}
\description{
The class BSVAR-SV presents complete specification for the BSVAR model with Stochastic Volatility heteroskedasticity.
}
\examples{
data(us_fiscal_lsuw)
spec = specify_bsvar_sv$new(
   data = us_fiscal_lsuw,
   p = 4
)


## ------------------------------------------------
## Method `specify_bsvar_sv$get_data_matrices`
## ------------------------------------------------

data(us_fiscal_lsuw)
spec = specify_bsvar_sv$new(
   data = us_fiscal_lsuw,
   p = 4
)
spec$get_data_matrices()


## ------------------------------------------------
## Method `specify_bsvar_sv$get_identification`
## ------------------------------------------------

data(us_fiscal_lsuw)
spec = specify_bsvar_sv$new(
   data = us_fiscal_lsuw,
   p = 4
)
spec$get_identification()


## ------------------------------------------------
## Method `specify_bsvar_sv$get_prior`
## ------------------------------------------------

data(us_fiscal_lsuw)
spec = specify_bsvar_sv$new(
   data = us_fiscal_lsuw,
   p = 4
)
spec$get_prior()


## ------------------------------------------------
## Method `specify_bsvar_sv$get_starting_values`
## ------------------------------------------------

data(us_fiscal_lsuw)
spec = specify_bsvar_sv$new(
   data = us_fiscal_lsuw,
   p = 4
)
spec$get_starting_values()

}
\seealso{
\code{\link{estimate_bsvar_sv}}, \code{\link{specify_posterior_bsvar_sv}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{p}}{a non-negative integer specifying the autoregressive lag order of the model.}

\item{\code{identification}}{an object IdentificationBSVARs with the identifying restrictions.}

\item{\code{prior}}{an object PriorBSVAR-SV with the prior specification.}

\item{\code{data_matrices}}{an object DataMatricesBSVAR with the data matrices.}

\item{\code{starting_values}}{an object StartingValuesBSVAR-SV with the starting values.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BSVAR-SV-new}{\code{specify_bsvar_sv$new()}}
\item \href{#method-BSVAR-SV-get_data_matrices}{\code{specify_bsvar_sv$get_data_matrices()}}
\item \href{#method-BSVAR-SV-get_identification}{\code{specify_bsvar_sv$get_identification()}}
\item \href{#method-BSVAR-SV-get_prior}{\code{specify_bsvar_sv$get_prior()}}
\item \href{#method-BSVAR-SV-get_starting_values}{\code{specify_bsvar_sv$get_starting_values()}}
\item \href{#method-BSVAR-SV-clone}{\code{specify_bsvar_sv$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVAR-SV-new"></a>}}
\if{latex}{\out{\hypertarget{method-BSVAR-SV-new}{}}}
\subsection{Method \code{new()}}{
Create a new specification of the BSVAR model with Stochastic Volatility heteroskedasticity, BSVAR-SV.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvar_sv$new(data, p = 1L, B, stationary = rep(FALSE, ncol(data)))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{a \code{(T+p)xN} matrix with time series data.}

\item{\code{p}}{a positive integer providing model's autoregressive lag order.}

\item{\code{B}}{a logical \code{NxN} matrix containing value \code{TRUE} for the elements of the structural matrix \eqn{B} to be estimated and value \code{FALSE} for exclusion restrictions to be set to zero.}

\item{\code{stationary}}{an \code{N} logical vector - its element set to \code{FALSE} sets the prior mean for the autoregressive parameters of the \code{N}th equation to the white noise process, otherwise to random walk.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new complete specification for the bsvar model with Stochastic Volatility heteroskedasticity, BSVAR-SV.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVAR-SV-get_data_matrices"></a>}}
\if{latex}{\out{\hypertarget{method-BSVAR-SV-get_data_matrices}{}}}
\subsection{Method \code{get_data_matrices()}}{
Returns the data matrices as the DataMatricesBSVAR object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvar_sv$get_data_matrices()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(us_fiscal_lsuw)
spec = specify_bsvar_sv$new(
   data = us_fiscal_lsuw,
   p = 4
)
spec$get_data_matrices()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVAR-SV-get_identification"></a>}}
\if{latex}{\out{\hypertarget{method-BSVAR-SV-get_identification}{}}}
\subsection{Method \code{get_identification()}}{
Returns the identifying restrictions as the IdentificationBSVARs object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvar_sv$get_identification()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(us_fiscal_lsuw)
spec = specify_bsvar_sv$new(
   data = us_fiscal_lsuw,
   p = 4
)
spec$get_identification()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVAR-SV-get_prior"></a>}}
\if{latex}{\out{\hypertarget{method-BSVAR-SV-get_prior}{}}}
\subsection{Method \code{get_prior()}}{
Returns the prior specification as the PriorBSVAR-SV object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvar_sv$get_prior()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(us_fiscal_lsuw)
spec = specify_bsvar_sv$new(
   data = us_fiscal_lsuw,
   p = 4
)
spec$get_prior()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVAR-SV-get_starting_values"></a>}}
\if{latex}{\out{\hypertarget{method-BSVAR-SV-get_starting_values}{}}}
\subsection{Method \code{get_starting_values()}}{
Returns the starting values as the StartingValuesBSVAR-SV object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvar_sv$get_starting_values()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(us_fiscal_lsuw)
spec = specify_bsvar_sv$new(
   data = us_fiscal_lsuw,
   p = 4
)
spec$get_starting_values()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVAR-SV-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BSVAR-SV-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvar_sv$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
