% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{svm}
\alias{svm}
\title{Stochastic Volatility Model}
\usage{
svm(y, mu, rho, sd_ar, sigma)
}
\arguments{
\item{y}{A numeric vector or a \code{\link{ts}} object of observations.}

\item{mu}{A prior for mu parameter of transition equation.
Should be an object of class \code{bssm_prior}.}

\item{rho}{A prior for autoregressive coefficient.
Should be an object of class \code{bssm_prior}.}

\item{sd_ar}{A prior for the standard deviation of noise of the AR-process.
Should be an object of class \code{bssm_prior}.}

\item{sigma}{A prior for sigma parameter of observation equation, internally
denoted as phi. Should be an object of class \code{bssm_prior}.
Ignored if \code{mu} is provided. Note that typically
parametrization using mu is preferred due to better numerical properties and
availability of better Gaussian approximation.
Most notably the global approximation approach does not work with sigma
parameterization as sigma is not a parameter of the resulting approximate
model.}
}
\value{
An object of class \code{svm}.
}
\description{
Constructs a simple stochastic volatility model with Gaussian errors and
first order autoregressive signal. See the main vignette for details.
}
\examples{

data("exchange")
y <- exchange[1:100] # for faster CRAN check
model <- svm(y, rho = uniform(0.98, -0.999, 0.999),
 sd_ar = halfnormal(0.15, 5), sigma = halfnormal(0.6, 2))

obj <- function(pars) {
   -logLik(svm(y, 
     rho = uniform(pars[1], -0.999, 0.999),
     sd_ar = halfnormal(pars[2], 5),
     sigma = halfnormal(pars[3], 2)), particles = 0)
}
opt <- optim(c(0.98, 0.15, 0.6), obj, 
  lower = c(-0.999, 1e-4, 1e-4),
  upper = c(0.999, 10, 10), method = "L-BFGS-B")
pars <- opt$par
model <- svm(y, 
  rho = uniform(pars[1],-0.999,0.999),
  sd_ar = halfnormal(pars[2], 5),
  sigma = halfnormal(pars[3], 2))

# alternative parameterization  
model2 <- svm(y, rho = uniform(0.98,-0.999, 0.999),
 sd_ar = halfnormal(0.15, 5), mu = normal(0, 0, 1))

obj2 <- function(pars) {
   -logLik(svm(y, 
     rho = uniform(pars[1], -0.999, 0.999),
     sd_ar = halfnormal(pars[2], 5),
     mu = normal(pars[3], 0, 1)), particles = 0)
}
opt2 <- optim(c(0.98, 0.15, 0), obj2, lower = c(-0.999, 1e-4, -Inf),
  upper = c(0.999, 10, Inf), method = "L-BFGS-B")
pars2 <- opt2$par
model2 <- svm(y, 
  rho = uniform(pars2[1],-0.999,0.999),
  sd_ar = halfnormal(pars2[2], 5),
  mu = normal(pars2[3], 0, 1))

# sigma is internally stored in phi
ts.plot(cbind(model$phi * exp(0.5 * fast_smoother(model)), 
  exp(0.5 * fast_smoother(model2))), col = 1:2)

}
