% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_sample.R
\name{expand_sample}
\alias{expand_sample}
\title{Expand the Jump Chain representation}
\usage{
expand_sample(x, variable = "theta", times, states, by_states = TRUE)
}
\arguments{
\item{x}{Output from \code{\link{run_mcmc}}.}

\item{variable}{Expand parameters \code{"theta"} or states \code{"states"}.}

\item{times}{A vector of indices. In case of states,
what time points to expand? Default is all.}

\item{states}{A vector of indices. In case of states,
what states to expand? Default is all.}

\item{by_states}{If \code{TRUE} (default), return list by states.
Otherwise by time.}
}
\value{
An object of class \code{"mcmc"} of the \code{coda} package.
}
\description{
The MCMC algorithms of \code{bssm} use a jump chain representation where we
store the accepted values and the number of times we stayed in the current
value. Although this saves bit memory and is especially convenient for
IS-corrected  MCMC, sometimes we want to have the usual sample paths
(for example for drawing traceplots).
Function \code{expand_sample} returns the expanded sample based on the
counts (in form of \code{coda::mcmc} object. Note that for
the IS-MCMC the expanded sample corresponds to the approximate posterior,
i.e., the weights are ignored.
}
\details{
This functions is mostly for backwards compatibility, methods
\code{as.data.frame} and \code{as_draws} produce likely more convenient
output.
}
\examples{
set.seed(1)
n <- 50
x <- cumsum(rnorm(n))
y <- rnorm(n, x)
model <- bsm_lg(y, sd_y = gamma_prior(1, 2, 2), 
  sd_level = gamma_prior(1, 2, 2))
fit <- run_mcmc(model, iter = 1e4)
# Traceplots for theta
plot.ts(expand_sample(fit, variable = "theta"))
# Traceplot for x_5
plot.ts(expand_sample(fit, variable = "states", times = 5, 
  states = 1)$level)
}
\seealso{
\code{as.data.frame.mcmc_output} and \code{as_draws.mcmc_output}.
}
