% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tooltip.R
\name{tooltip}
\alias{tooltip}
\alias{toggle_tooltip}
\alias{update_tooltip}
\title{Add a tooltip to a UI element}
\usage{
tooltip(
  trigger,
  ...,
  id = NULL,
  placement = c("auto", "top", "right", "bottom", "left"),
  options = list()
)

toggle_tooltip(id, show = NULL, session = get_current_session())

update_tooltip(id, ..., session = get_current_session())
}
\arguments{
\item{trigger}{A UI element (i.e., \link[htmltools:builder]{htmltools tag}) to serve
as the tooltip trigger. If \code{trigger} renders as multiple HTML
elements (e.g., it's a \code{tagList()}), the last HTML element is used for the
trigger. If the \code{trigger} should contain all of those elements, wrap the
object in a \code{\link[=div]{div()}} or \code{\link[=span]{span()}}.}

\item{...}{UI elements for the tooltip. Character strings are \link[=htmlEscape]{automatically escaped} unless marked as \code{\link[=HTML]{HTML()}}.}

\item{id}{a character string that matches an existing tooltip id.}

\item{placement}{The placement of the tooltip relative to its trigger.}

\item{options}{A list of additional \href{https://getbootstrap.com/docs/5.3/components/tooltips/#options}{options}.}

\item{show}{Whether to show (\code{TRUE}) or hide (\code{FALSE}) the tooltip. The
default (\code{NULL}) will show if currently hidden and hide if currently shown.
Note that a tooltip will not be shown if the trigger is not visible (e.g.,
it's hidden behind a tab).}

\item{session}{A Shiny session object (the default should almost always be
used).}
}
\description{
Display additional information when focusing (or hovering over) a UI element.
}
\section{Functions}{
\itemize{
\item \code{tooltip()}: Add a tooltip to a UI element

\item \code{toggle_tooltip()}: Programmatically show/hide a tooltip.

\item \code{update_tooltip()}: Update the contents of a tooltip.

}}
\section{Theming/Styling}{


Like other bslib components, tooltips can be themed by supplying \href{https://rstudio.github.io/bslib/articles/bs5-variables/index.html#tooltip-bg}{relevant theming variables}
to \code{\link[=bs_theme]{bs_theme()}}, which effects styling of every popover on the page. To
style a \emph{specific} popover differently from other popovers, utilize the
\code{customClass} option:

\if{html}{\out{<div class="sourceCode">}}\preformatted{tooltip(
  "Trigger", "Tooltip message",
  options = list(customClass = "my-tip")
)
}\if{html}{\out{</div>}}

And then add relevant rules to \code{\link[=bs_theme]{bs_theme()}} via \code{\link[=bs_add_rules]{bs_add_rules()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{bs_theme() |> bs_add_rules(".my-tip \{ max-width: none; \}")
}\if{html}{\out{</div>}}
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

tooltip(
  shiny::actionButton("btn", "A button"),
  "A message"
)

card(
  card_header(
    tooltip(
      span("Card title ", bsicons::bs_icon("question-circle-fill")),
      "Additional info",
      placement = "right"
    )
  ),
  "Card body content..."
)
\dontshow{\}) # examplesIf}
}
\references{
\url{https://getbootstrap.com/docs/5.3/components/tooltips/}
}
\seealso{
\code{\link[=popover]{popover()}}
}
