var menuOutputBinding = new Shiny.OutputBinding();
$.extend(menuOutputBinding, {
  find: function (scope) {
    return $(scope).find('.bs4Dash-menu-output');
  },
  onValueError: function (el, err) {
    Shiny.unbindAll(el);
    this.renderError(el, err);
  },
  renderValue: function (el, data) {
    Shiny.unbindAll(el);

    var html;
    var dependencies = [];
    if (data === null) {
      return;
    } else if (typeof (data) === 'string') {
      html = data;
    } else if (typeof (data) === 'object') {
      html = data.html;
      dependencies = data.deps;
    }

    var $html = $($.parseHTML(html));

    // Convert the inner contents to HTML, and pass to renderHtml
    Shiny.renderHtml($html.html(), el, dependencies);

    // Extract class of wrapper, and add them to the wrapper element
    el.className = 'bs4Dash-menu-output shiny-bound-output ' +
      $html.attr('class');
    
    // need this to activate adminLTE3 plugin for treeview  
    $(el)
      .attr("data-widget", "treeview")
      .attr("role", "menu")
      .attr("data-accordion", "true");

    Shiny.initializeInputs(el);
    Shiny.bindAll(el);
    if ($(el).hasClass("sidebar-menu")) ensureActivatedTab(); // eslint-disable-line
  }
});
Shiny.outputBindings.register(menuOutputBinding, "bs4Dash.menuOutputBinding");
