% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_list_variables.R
\name{model_list_variables}
\alias{model_list_variables}
\alias{model_list_variables.default}
\alias{model_list_variables.lavaan}
\alias{model_list_variables.logitr}
\title{List all the variables used in a model}
\usage{
model_list_variables(
  model,
  labels = NULL,
  only_variable = FALSE,
  add_var_type = FALSE
)

\method{model_list_variables}{default}(
  model,
  labels = NULL,
  only_variable = FALSE,
  add_var_type = FALSE
)

\method{model_list_variables}{lavaan}(
  model,
  labels = NULL,
  only_variable = FALSE,
  add_var_type = FALSE
)

\method{model_list_variables}{logitr}(
  model,
  labels = NULL,
  only_variable = FALSE,
  add_var_type = FALSE
)
}
\arguments{
\item{model}{a model object}

\item{labels}{an optional named list or named vector of
custom variable labels}

\item{only_variable}{if \code{TRUE}, will return only "variable"
column}

\item{add_var_type}{if \code{TRUE}, add \code{var_nlevels} and \code{var_type} columns}
}
\value{
A tibble with three columns:
\itemize{
\item \code{variable}: the corresponding variable
\item \code{var_class}: class of the variable (cf. \code{\link[stats:checkMFClasses]{stats::.MFclass()}})
\item \code{label_attr}: variable label defined in the original data frame
with the label attribute (cf. \code{\link[labelled:var_label]{labelled::var_label()}})
\item \code{var_label}: a variable label (by priority, \code{labels} if defined,
\code{label_attr} if available, otherwise \code{variable})
}

If \code{add_var_type = TRUE}:
\itemize{
\item \code{var_type}: \code{"continuous"}, \code{"dichotomous"} (categorical variable with 2 levels),
\code{"categorical"} (categorical variable with 3 or more levels), \code{"intercept"}
or \code{"interaction"}
\item \code{var_nlevels}: number of original levels for categorical variables
}
}
\description{
Including variables used only in an interaction.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
if (.assert_package("gtsummary", boolean = TRUE)) {
  df <- Titanic |>
    dplyr::as_tibble() |>
    dplyr::mutate(Survived = factor(Survived, c("No", "Yes")))
  glm(
    Survived ~ Class + Age:Sex,
    data = df, weights = df$n,
    family = binomial
  ) |>
  model_list_variables()

  iris |>
    lm(
      Sepal.Length ~ poly(Sepal.Width, 2) + Species,
      data = _,
      contrasts = list(Species = contr.sum)
    ) |>
    model_list_variables()

  glm(
    response ~ poly(age, 3) + stage + grade * trt,
    na.omit(gtsummary::trial),
    family = binomial,
  ) |>
    model_list_variables()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other model_helpers: 
\code{\link{model_compute_terms_contributions}()},
\code{\link{model_get_assign}()},
\code{\link{model_get_coefficients_type}()},
\code{\link{model_get_contrasts}()},
\code{\link{model_get_model}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_model_matrix}()},
\code{\link{model_get_n}()},
\code{\link{model_get_nlevels}()},
\code{\link{model_get_offset}()},
\code{\link{model_get_pairwise_contrasts}()},
\code{\link{model_get_response}()},
\code{\link{model_get_response_variable}()},
\code{\link{model_get_terms}()},
\code{\link{model_get_weights}()},
\code{\link{model_get_xlevels}()},
\code{\link{model_identify_variables}()},
\code{\link{model_list_contrasts}()},
\code{\link{model_list_higher_order_variables}()},
\code{\link{model_list_terms_levels}()}
}
\concept{model_helpers}
