% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{R2D2}
\alias{R2D2}
\title{R2D2 Priors in \pkg{brms}}
\usage{
R2D2(mean_R2 = 0.5, prec_R2 = 2, cons_D2 = 0.5, autoscale = TRUE, main = FALSE)
}
\arguments{
\item{mean_R2}{Mean of the Beta prior on the coefficient of determination R^2.}

\item{prec_R2}{Precision of the Beta prior on the coefficient of determination R^2.}

\item{cons_D2}{Concentration vector of the Dirichlet prior on the variance
decomposition parameters. Lower values imply more shrinkage.}

\item{autoscale}{Logical; indicating whether the R2D2
prior should be scaled using the residual standard deviation
\code{sigma} if possible and sensible (defaults to \code{TRUE}).
Autoscaling is not applied for distributional parameters or
when the model does not contain the parameter \code{sigma}.}

\item{main}{Logical (defaults to \code{FALSE}); only relevant if the R2D2
prior spans multiple parameter classes. In this case, only arguments given
in the single instance where \code{main} is \code{TRUE} will be used.
Arguments given in other instances of the prior will be ignored.
See the Examples section below.}
}
\description{
Function used to set up R2D2(M2) priors in \pkg{brms}. The function does
not evaluate its arguments -- it exists purely to help set up the model.
}
\details{
The prior does not account for scale differences of the terms it is
  applied on. Accordingly, please make sure that all these terms have a
  comparable scale to ensure that shrinkage is applied properly.

  Currently, the following classes support the R2D2(M2) prior: \code{b}
  (overall regression coefficients), \code{sds} (SDs of smoothing splines),
  \code{sdgp} (SDs of Gaussian processes), \code{ar} (autoregressive
  coefficients), \code{ma} (moving average coefficients), \code{sderr} (SD of
  latent residuals), \code{sdcar} (SD of spatial CAR structures), \code{sd}
  (SD of varying coefficients).

  When the prior is only applied to parameter class \code{b}, it is equivalent
  to the original R2D2 prior (with Gaussian kernel). When the prior is also
  applied to other parameter classes, it is equivalent to the R2D2M2 prior.

  Even when the R2D2(M2) prior is applied to multiple parameter classes at once,
  the concentration vector (argument \code{cons_D2}) has to be provided
  jointly in the the one instance of the prior where \code{main = TRUE}. The
  order in which the elements of concentration vector correspond to the
  classes' coefficients is the same as the order of the classes provided
  above.
}
\examples{
set_prior(R2D2(mean_R2 = 0.8, prec_R2 = 10))

# specify the R2D2 prior across multiple parameter classes
set_prior(R2D2(mean_R2 = 0.8, prec_R2 = 10, main = TRUE), class = "b") +
  set_prior(R2D2(), class = "sd")

}
\references{
Zhang, Y. D., Naughton, B. P., Bondell, H. D., & Reich, B. J. (2020).
Bayesian regression using a prior on the model fit: The R2-D2 shrinkage
prior. Journal of the American Statistical Association.
\url{https://arxiv.org/pdf/1609.00046.pdf}

Aguilar J. E. & Bürkner P. C. (2022). Intuitive Joint Priors for Bayesian
Linear Multilevel Models: The R2D2M2 prior. ArXiv preprint.
\url{https://arxiv.org/pdf/2208.07132.pdf}
}
\seealso{
\code{\link{set_prior}}
}
