% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo.R
\name{psis.brmsfit}
\alias{psis.brmsfit}
\alias{psis}
\title{Pareto smoothed importance sampling (PSIS)}
\usage{
\method{psis}{brmsfit}(log_ratios, newdata = NULL, resp = NULL, model_name = NULL, ...)
}
\arguments{
\item{log_ratios}{A fitted model object of class \code{brmsfit}.
Argument is named "log_ratios" to match the argument name of the
\code{\link[loo:psis]{loo::psis}} generic function.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used.
\code{NA} values within factors are interpreted as if all dummy
variables of this factor are zero. This allows, for instance, to make
predictions of the grand mean when using sum coding.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{model_name}{Currently ignored.}

\item{...}{Further arguments passed to \code{\link{log_lik}} and
\code{\link[loo:psis]{loo::psis}}.}
}
\value{
The \code{psis()} methods return an object of class \code{"psis"},
which is a named list with the following components:

\describe{
\item{\code{log_weights}}{
Vector or matrix of smoothed (and truncated) but \emph{unnormalized} log
weights. To get normalized weights use the
\code{\link[loo:weights.importance_sampling]{weights()}} method provided for objects of
class \code{"psis"}.
}
\item{\code{diagnostics}}{
A named list containing two vectors:
\itemize{
\item \code{pareto_k}: Estimates of the shape parameter \eqn{k} of the
generalized Pareto distribution. See the \link[loo]{pareto-k-diagnostic}
page for details.
\item \code{n_eff}: PSIS effective sample size estimates.
}
}
}

Objects of class \code{"psis"} also have the following \link[=attributes]{attributes}:
\describe{
\item{\code{norm_const_log}}{
Vector of precomputed values of \code{colLogSumExps(log_weights)} that are
used internally by the \code{weights} method to normalize the log weights.
}
\item{\code{tail_len}}{
Vector of tail lengths used for fitting the generalized Pareto distribution.
}
\item{\code{r_eff}}{
If specified, the user's \code{r_eff} argument.
}
\item{\code{dims}}{
Integer vector of length 2 containing \code{S} (posterior sample size)
and \code{N} (number of observations).
}
\item{\code{method}}{
Method used for importance sampling, here \code{psis}.
}
}
}
\description{
Implementation of Pareto smoothed importance sampling (PSIS), a method for
stabilizing importance ratios. The version of PSIS implemented here
corresponds to the algorithm presented in Vehtari, Simpson, Gelman, Yao,
and Gabry (2019).
For PSIS diagnostics see the \link[loo]{pareto-k-diagnostic} page.
}
\examples{
\dontrun{
fit <- brm(rating ~ treat + period + carry, data = inhaler)
psis(fit)
}
}
\references{
Vehtari, A., Gelman, A., and Gabry, J. (2017). Practical Bayesian model
evaluation using leave-one-out cross-validation and WAIC.
\emph{Statistics and Computing}. 27(5), 1413--1432. doi:10.1007/s11222-016-9696-4
(\href{https://link.springer.com/article/10.1007/s11222-016-9696-4}{journal version},
\href{https://arxiv.org/abs/1507.04544}{preprint arXiv:1507.04544}).

Vehtari, A., Simpson, D., Gelman, A., Yao, Y., and Gabry, J. (2019).
Pareto smoothed importance sampling.
\href{https://arxiv.org/abs/1507.02646}{preprint arXiv:1507.02646}
}
