% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_simulate_prior.R
\name{brm_simulate_prior}
\alias{brm_simulate_prior}
\title{Prior predictive draws.}
\usage{
brm_simulate_prior(
  data,
  formula,
  prior = brms.mmrm::brm_prior_simple(data = data, formula = formula),
  ...
)
}
\arguments{
\item{data}{A classed data frame from \code{\link[=brm_data]{brm_data()}}, or an informative
prior archetype from a function like \code{\link[=brm_archetype_successive_cells]{brm_archetype_successive_cells()}}.}

\item{formula}{An object of class \code{"brmsformula"} from \code{\link[=brm_formula]{brm_formula()}}
or \code{brms::brmsformula()}. Should include the full mapping
of the model, including fixed effects, residual correlation,
and heterogeneity in the discrete-time-specific residual variance
components.}

\item{prior}{A valid \code{brms} prior object with proper priors for parameters
\code{b} (model coefficients), \code{b_sigma} (log residual standard deviations
for each time point), and \code{cortime} (residual correlations among
time points within patients). See the
\code{\link[=brm_prior_simple]{brm_prior_simple()}} function for an example.}

\item{...}{Arguments to \code{brms::brm()} other than \code{data}, \code{formula},
and \code{prior}.}
}
\value{
A list with the following elements:
\itemize{
\item \code{data}: a classed \code{tibble} with the outcome variable simulated as a draw
from the prior predictive distribution (the final row of \code{outcome} in
the output). If you simulated a missingness pattern
with \code{\link[=brm_simulate_outline]{brm_simulate_outline()}}, then that missingness pattern is applied
so that the appropriate values of the outcome variable are set to \code{NA}.
\item \code{model}: the \code{brms} model fit object.
\item \code{model_matrix}: the model matrix of the fixed effects, obtained from
\code{brms::make_standata()}.
\item \code{outcome}: a numeric matrix with one column per row of \code{data} and one
row per saved prior predictive draw.
\item \code{parameters}: a \code{tibble} of saved parameter draws from the prior
predictive distribution.
}
}
\description{
Simulate the outcome variable from the prior
predictive distribution of an MMRM using \code{brms}.
}
\details{
\code{brm_simulate_prior()} calls \code{brms::brm()} with
\code{sample_prior = "only"}, which sets the default intercept prior
using the outcome variable and requires at least some elements of the
outcome variable to be non-missing in advance. So to provide feasible and
consistent output, \code{brm_simulate_prior()} temporarily sets the
outcome variable to all zeros before invoking \code{brms::brm()}.
}
\examples{
if (identical(Sys.getenv("BRM_EXAMPLES", unset = ""), "true")) {
set.seed(0L)
data <- brm_simulate_outline()
data <- brm_simulate_continuous(data, names = c("age", "biomarker"))
data$response <- rnorm(nrow(data))
formula <- brm_formula(
  data = data,
  baseline = FALSE,
  baseline_time = FALSE
)
tmp <- utils::capture.output(
  suppressMessages(
    suppressWarnings(
      out <- brm_simulate_prior(
        data = data,
        formula = formula
      )
    )
  )
)
out$data
}
}
\seealso{
Other simulation: 
\code{\link{brm_simulate_categorical}()},
\code{\link{brm_simulate_continuous}()},
\code{\link{brm_simulate_outline}()},
\code{\link{brm_simulate_simple}()}
}
\concept{simulation}
