% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.brm.R
\name{predict.brm}
\alias{predict.brm}
\title{Fitted probabilities from \code{brm} fits}
\usage{
\method{predict}{brm}(object, x.new = NULL, va.new = NULL, vb.new = NULL, ...)
}
\arguments{
\item{object}{A fitted object from function \code{brm}.}

\item{x.new}{An optional vector of x.}

\item{va.new}{An optional covariate matrix to make predictions with. If omitted, the original matrix va is used.}

\item{vb.new}{An optional covariate matrix to make predictions with. If vb.new is omitted but va.new is not, then vb.new is set to be equal to va.new. If both vb.new and va.new are omitted, then the original matrix vb is used.}

\item{...}{affecting the predictions produced.}
}
\value{
If x.new is omitted, a matrix consisting of fitted probabilities for p0 = P(y=1|x=0,va,vb) and p1 = P(y=1|x=1,va,vb).

If x.new is supplied, a vector consisting of fitted probabilities px = P(y=1|x=x.new,va,vb).
}
\description{
Calculate fitted probabilities from a fitted binary regression model object.
}
