% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProbScalarRD.R
\name{getProbRD}
\alias{getProbRD}
\title{Calculate risks from arctanh RD and log OP (vectorised)}
\usage{
getProbRD(atanhrd, logop)
}
\arguments{
\item{atanhrd}{arctanh of risk difference}

\item{logop}{log of odds product}
}
\value{
a matrix \eqn{(P(y=1|x=0),P(y=1|x=1))} with two columns
}
\description{
Calculate risks from arctanh RD and log OP (vectorised)
}
\details{
The \eqn{log OP} is defined as \eqn{log OP = log[(P(y=1|x=0)/P(y=0|x=0))*(P(y=1|x=1)/P(y=0|x=1))]}. 
The inverse hyperbolic tangent function \code{arctanh} is defined as \eqn{arctanh(z) = [log(1+z) - log(1-z)] / 2}.
}
\examples{
getProbRD(0,0)

set.seed(0)
logrr = rnorm(10,0,1)
logop = rnorm(10,0,1)
probs = getProbRD(logrr, logop)
colnames(probs) = c("P(y=1|x=0)","P(y=1|x=1)")
probs

}
