% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnmr.R
\name{bnmr}
\alias{bnmr}
\title{Causal inference between traits using the Bayesian Network-based Mendelian randomization}
\usage{
bnmr(
  df,
  snp,
  exposureName,
  outcomeName,
  bn_method = "hc",
  repeats = 1000,
  selectNum = NA,
  alpha = 0.5,
  nsam = 1000,
  psam = 100,
  sample_replace = TRUE,
  mr_model = "linear",
  prior = "horseshoe",
  init = "median",
  n.iter = 5000,
  n.chain = 4
)
}
\arguments{
\item{df}{a data frame which contains data of SNPs and specified exposure. The values of snps in the data frame should be either numeric or factors (not integers) for BN learning.}

\item{snp}{a vector of string belonging to column names of df, which is the name of SNPs included in BN structure learning.}

\item{exposureName}{a string which is a colname of df corresponding to the exposure studied.}

\item{outcomeName}{a string which is a column name of df corresponding to the outcome studied.}

\item{bn_method}{method for BN structure learning. Possible values are the function name of structure learning algorithm implemented in bnlearn. Default is "hc".}

\item{repeats}{an integer standing for the number of subsamples or bootstraps. Default is 1000.}

\item{selectNum}{the number of instrument to select. Default is NA.}

\item{alpha}{a number between 0 and 1 to specify the threshold for IV selection. We will use a threshold for variant selection as alpha*psam/length(snp). If selectNum is specified, the parameter will not be used. Default is 0.5.}

\item{nsam}{the size of individuals in each subsample of random graph forest. Default is 1000.}

\item{psam}{the size of variants in each subsample of random graph forest. Default is 100.}

\item{sample_replace}{is a boolean value to determine the sampling methods for individuals. TRUE with replacement and FALSE without replacement. Default is TRUE.}

\item{mr_model}{model for MR. Possible values are "linear" or "logit". Default is "linear".}

\item{prior}{a string represented shrinkage prior used in estimation. It can be "horseshoe", "lasso", "hyperlasso", "spikeslabBernoulli", "spikeslabUniform". Default is "horseshoe".}

\item{init}{the init value of theta for MCMC estimation. It can be a specific numeric or a string of "TSLS", "median", "egger" and "ivw", which means the initial value of the iteration will be calculated automatically by the above method. Default is "median".}

\item{n.iter}{an integer standing for the number of iterations. Default is 5000.}

\item{n.chain}{the number of chains in MCMC sampling. Default is 4.}
}
\value{
a list containing:
  \item{selectsnp}{a vector of string containing the colnames of df corresponding to selected SNPs.}
  \item{dfscore}{a data frame containing the score calculated for each SNP.}
  \item{betaList}{a vector cantaining the posterior of the causal parameter of interest using MCMC sampling.}
  \item{mean}{the mean estimate of the causal parameter.}
  \item{se}{the standard error of the estimation.}
  \item{lower}{the lower boundary of the 95\% CI of the causal estimation.}
  \item{upper}{the upper boundary of the 95\% CI of the causal estimation.}
  \item{Rhat}{an indicator to measure the convergence (at convergence, Rhat <= 1.1).}
  \item{fit_detail}{an S4 class stanfit object containing the details of Bayesian MR estimation}
}
\description{
Causal inference between traits using the Bayesian Network-based Mendelian randomization
}
\examples{
n <- 2000
p <- 200
snps <- replicate(p,sample(0:2,n,replace = TRUE))
snps <- apply(snps,2,as.numeric)
snpname <- paste0("g",1:p)
df <- as.data.frame(snps)
colnames(df) <- snpname
truesnp <- paste0("g",sample(1:p,50))
df$x <- as.matrix(df[,truesnp])\%*\%rnorm(50,0.05,0.05)+rnorm(n,0,1)
df$y <- 0.5*df$x+rnorm(n,0,1)
model <- bnmr(df,snpname,"x","y")

}
