% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnmr.R
\name{bnmr}
\alias{bnmr}
\title{Bayesin Nonparametric Monotone Regression}
\usage{
bnmr(y, x, M, niter, nburn = round(niter/2), nthin = 1, priors)
}
\arguments{
\item{y}{vector of outcomes}

\item{x}{vector of predictors}

\item{M}{order of the Bernstein polynomial basis to be used.}

\item{niter}{number of iterations including burnin.}

\item{nburn}{number of iteractions discarded as burnin.}

\item{nthin}{thining number for posterior sample.}

\item{priors}{a list of priors. The list may contain elements alpha_a, alpha_b, pi_a, pi_b, mu0, and phi0 all scalars. The prios assigned will be alpha~Gamma(alpha_a,alpha_b), pi~beta(pi_a,pi_b), mu~N(mu0,phi0^2), theta_0~Normal(0,intsd^2).  The defaults are: alpha_a=1, alpha_b=1, pi_a=1, pi_b=1, mu0=0.5, phi0=0.25, intsd=2.}
}
\description{
Bayesin Nonparametric Monotone Regression
}
