// Generated by rstantools.  Do not edit by hand.

/*
    bmgarch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bmgarch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bmgarch.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_CCCMGARCH_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'CCCMGARCH', line 137, column 0 to column 16)",
                                                      " (in 'CCCMGARCH', line 142, column 0 to column 41)",
                                                      " (in 'CCCMGARCH', line 143, column 0 to column 43)",
                                                      " (in 'CCCMGARCH', line 149, column 0 to column 16)",
                                                      " (in 'CCCMGARCH', line 151, column 2 to column 17)",
                                                      " (in 'CCCMGARCH', line 153, column 2 to column 35)",
                                                      " (in 'CCCMGARCH', line 154, column 2 to column 41)",
                                                      " (in 'CCCMGARCH', line 155, column 2 to column 35)",
                                                      " (in 'CCCMGARCH', line 156, column 2 to column 23)",
                                                      " (in 'CCCMGARCH', line 159, column 2 to column 20)",
                                                      " (in 'CCCMGARCH', line 161, column 2 to column 32)",
                                                      " (in 'CCCMGARCH', line 163, column 2 to column 23)",
                                                      " (in 'CCCMGARCH', line 166, column 2 to column 28)",
                                                      " (in 'CCCMGARCH', line 167, column 2 to column 27)",
                                                      " (in 'CCCMGARCH', line 168, column 2 to column 25)",
                                                      " (in 'CCCMGARCH', line 169, column 2 to column 24)",
                                                      " (in 'CCCMGARCH', line 170, column 2 to column 31)",
                                                      " (in 'CCCMGARCH', line 171, column 2 to column 33)",
                                                      " (in 'CCCMGARCH', line 172, column 2 to column 33)",
                                                      " (in 'CCCMGARCH', line 173, column 2 to column 84)",
                                                      " (in 'CCCMGARCH', line 174, column 2 to column 37)",
                                                      " (in 'CCCMGARCH', line 175, column 2 to column 54)",
                                                      " (in 'CCCMGARCH', line 176, column 2 to column 82)",
                                                      " (in 'CCCMGARCH', line 179, column 2 to column 16)",
                                                      " (in 'CCCMGARCH', line 181, column 2 to column 18)",
                                                      " (in 'CCCMGARCH', line 182, column 2 to column 35)",
                                                      " (in 'CCCMGARCH', line 195, column 2 to column 36)",
                                                      " (in 'CCCMGARCH', line 193, column 32 to line 196, column 2)",
                                                      " (in 'CCCMGARCH', line 193, column 8 to line 196, column 2)",
                                                      " (in 'CCCMGARCH', line 192, column 2 to column 71)",
                                                      " (in 'CCCMGARCH', line 190, column 32 to line 193, column 2)",
                                                      " (in 'CCCMGARCH', line 190, column 8 to line 196, column 2)",
                                                      " (in 'CCCMGARCH', line 189, column 2 to column 17)",
                                                      " (in 'CCCMGARCH', line 187, column 24 to line 190, column 2)",
                                                      " (in 'CCCMGARCH', line 187, column 0 to line 196, column 2)",
                                                      " (in 'CCCMGARCH', line 200, column 6 to column 18)",
                                                      " (in 'CCCMGARCH', line 201, column 6 to column 20)",
                                                      " (in 'CCCMGARCH', line 202, column 6 to column 20)",
                                                      " (in 'CCCMGARCH', line 205, column 1 to column 49)",
                                                      " (in 'CCCMGARCH', line 206, column 1 to column 43)",
                                                      " (in 'CCCMGARCH', line 204, column 33 to line 207, column 7)",
                                                      " (in 'CCCMGARCH', line 204, column 6 to line 207, column 7)",
                                                      " (in 'CCCMGARCH', line 209, column 1 to column 43)",
                                                      " (in 'CCCMGARCH', line 208, column 33 to line 210, column 7)",
                                                      " (in 'CCCMGARCH', line 208, column 6 to line 210, column 7)",
                                                      " (in 'CCCMGARCH', line 214, column 7 to column 50)",
                                                      " (in 'CCCMGARCH', line 213, column 34 to line 215, column 7)",
                                                      " (in 'CCCMGARCH', line 213, column 13 to line 215, column 7)",
                                                      " (in 'CCCMGARCH', line 212, column 1 to column 64)",
                                                      " (in 'CCCMGARCH', line 211, column 27 to line 213, column 7)",
                                                      " (in 'CCCMGARCH', line 211, column 6 to line 215, column 7)",
                                                      " (in 'CCCMGARCH', line 216, column 6 to column 30)",
                                                      " (in 'CCCMGARCH', line 199, column 20 to line 217, column 5)",
                                                      " (in 'CCCMGARCH', line 199, column 4 to line 217, column 5)",
                                                      " (in 'CCCMGARCH', line 218, column 2 to column 35)",
                                                      " (in 'CCCMGARCH', line 184, column 16 to line 219, column 3)",
                                                      " (in 'CCCMGARCH', line 184, column 2 to line 219, column 3)",
                                                      " (in 'CCCMGARCH', line 250, column 2 to column 23)",
                                                      " (in 'CCCMGARCH', line 251, column 2 to column 24)",
                                                      " (in 'CCCMGARCH', line 252, column 2 to column 32)",
                                                      " (in 'CCCMGARCH', line 253, column 2 to column 41)",
                                                      " (in 'CCCMGARCH', line 265, column 4 to column 57)",
                                                      " (in 'CCCMGARCH', line 266, column 4 to column 30)",
                                                      " (in 'CCCMGARCH', line 267, column 4 to column 67)",
                                                      " (in 'CCCMGARCH', line 264, column 17 to line 268, column 3)",
                                                      " (in 'CCCMGARCH', line 264, column 2 to line 268, column 3)",
                                                      " (in 'CCCMGARCH', line 263, column 33 to line 269, column 2)",
                                                      " (in 'CCCMGARCH', line 263, column 8 to line 269, column 2)",
                                                      " (in 'CCCMGARCH', line 259, column 4 to column 50)",
                                                      " (in 'CCCMGARCH', line 260, column 4 to column 30)",
                                                      " (in 'CCCMGARCH', line 261, column 4 to column 60)",
                                                      " (in 'CCCMGARCH', line 258, column 17 to line 262, column 3)",
                                                      " (in 'CCCMGARCH', line 258, column 2 to line 262, column 3)",
                                                      " (in 'CCCMGARCH', line 257, column 24 to line 263, column 2)",
                                                      " (in 'CCCMGARCH', line 257, column 0 to line 269, column 2)",
                                                      " (in 'CCCMGARCH', line 224, column 4 to column 32)",
                                                      " (in 'CCCMGARCH', line 225, column 4 to column 58)",
                                                      " (in 'CCCMGARCH', line 223, column 17 to line 226, column 3)",
                                                      " (in 'CCCMGARCH', line 223, column 2 to line 226, column 3)",
                                                      " (in 'CCCMGARCH', line 227, column 2 to column 34)",
                                                      " (in 'CCCMGARCH', line 228, column 2 to column 33)",
                                                      " (in 'CCCMGARCH', line 230, column 4 to column 26)",
                                                      " (in 'CCCMGARCH', line 229, column 2 to line 230, column 26)",
                                                      " (in 'CCCMGARCH', line 231, column 2 to column 39)",
                                                      " (in 'CCCMGARCH', line 232, column 2 to column 35)",
                                                      " (in 'CCCMGARCH', line 233, column 2 to column 33)",
                                                      " (in 'CCCMGARCH', line 234, column 2 to column 53)",
                                                      " (in 'CCCMGARCH', line 235, column 2 to column 20)",
                                                      " (in 'CCCMGARCH', line 244, column 6 to column 51)",
                                                      " (in 'CCCMGARCH', line 243, column 17 to line 246, column 5)",
                                                      " (in 'CCCMGARCH', line 243, column 4 to line 246, column 5)",
                                                      " (in 'CCCMGARCH', line 242, column 34 to line 247, column 3)",
                                                      " (in 'CCCMGARCH', line 242, column 9 to line 247, column 3)",
                                                      " (in 'CCCMGARCH', line 239, column 6 to column 44)",
                                                      " (in 'CCCMGARCH', line 238, column 17 to line 241, column 5)",
                                                      " (in 'CCCMGARCH', line 238, column 4 to line 241, column 5)",
                                                      " (in 'CCCMGARCH', line 237, column 27 to line 242, column 3)",
                                                      " (in 'CCCMGARCH', line 237, column 2 to line 247, column 3)",
                                                      " (in 'CCCMGARCH', line 95, column 0 to column 15)",
                                                      " (in 'CCCMGARCH', line 96, column 0 to column 16)",
                                                      " (in 'CCCMGARCH', line 97, column 0 to column 15)",
                                                      " (in 'CCCMGARCH', line 98, column 0 to column 15)",
                                                      " (in 'CCCMGARCH', line 99, column 6 to column 7)",
                                                      " (in 'CCCMGARCH', line 99, column 16 to column 18)",
                                                      " (in 'CCCMGARCH', line 99, column 0 to column 24)",
                                                      " (in 'CCCMGARCH', line 100, column 6 to column 7)",
                                                      " (in 'CCCMGARCH', line 100, column 16 to column 18)",
                                                      " (in 'CCCMGARCH', line 100, column 0 to column 23)",
                                                      " (in 'CCCMGARCH', line 101, column 0 to column 35)",
                                                      " (in 'CCCMGARCH', line 102, column 0 to column 36)",
                                                      " (in 'CCCMGARCH', line 106, column 9 to column 11)",
                                                      " (in 'CCCMGARCH', line 106, column 2 to column 19)",
                                                      " (in 'CCCMGARCH', line 107, column 9 to column 11)",
                                                      " (in 'CCCMGARCH', line 107, column 2 to column 20)",
                                                      " (in 'CCCMGARCH', line 110, column 6 to column 7)",
                                                      " (in 'CCCMGARCH', line 110, column 16 to column 18)",
                                                      " (in 'CCCMGARCH', line 110, column 20 to column 22)",
                                                      " (in 'CCCMGARCH', line 110, column 0 to column 29)",
                                                      " (in 'CCCMGARCH', line 111, column 0 to column 29)",
                                                      " (in 'CCCMGARCH', line 112, column 0 to column 19)",
                                                      " (in 'CCCMGARCH', line 115, column 2 to column 33)",
                                                      " (in 'CCCMGARCH', line 117, column 2 to column 33)",
                                                      " (in 'CCCMGARCH', line 119, column 4 to column 30)",
                                                      " (in 'CCCMGARCH', line 118, column 2 to line 119, column 30)",
                                                      " (in 'CCCMGARCH', line 114, column 15 to line 120, column 2)",
                                                      " (in 'CCCMGARCH', line 114, column 0 to line 120, column 2)",
                                                      " (in 'CCCMGARCH', line 129, column 1 to column 21)",
                                                      " (in 'CCCMGARCH', line 130, column 1 to column 25)",
                                                      " (in 'CCCMGARCH', line 128, column 23 to line 131, column 7)",
                                                      " (in 'CCCMGARCH', line 128, column 6 to line 131, column 7)",
                                                      " (in 'CCCMGARCH', line 126, column 54 to line 132, column 5)",
                                                      " (in 'CCCMGARCH', line 126, column 9 to line 132, column 5)",
                                                      " (in 'CCCMGARCH', line 123, column 6 to column 31)",
                                                      " (in 'CCCMGARCH', line 124, column 6 to column 30)",
                                                      " (in 'CCCMGARCH', line 122, column 21 to line 125, column 5)",
                                                      " (in 'CCCMGARCH', line 122, column 4 to line 125, column 5)",
                                                      " (in 'CCCMGARCH', line 121, column 26 to line 126, column 3)",
                                                      " (in 'CCCMGARCH', line 121, column 2 to line 132, column 5)",
                                                      " (in 'CCCMGARCH', line 137, column 7 to column 9)",
                                                      " (in 'CCCMGARCH', line 142, column 30 to column 32)",
                                                      " (in 'CCCMGARCH', line 142, column 33 to column 35)",
                                                      " (in 'CCCMGARCH', line 143, column 30 to column 32)",
                                                      " (in 'CCCMGARCH', line 143, column 33 to column 35)",
                                                      " (in 'CCCMGARCH', line 149, column 7 to column 9)",
                                                      " (in 'CCCMGARCH', line 151, column 9 to column 11)",
                                                      " (in 'CCCMGARCH', line 153, column 8 to column 10)",
                                                      " (in 'CCCMGARCH', line 153, column 20 to column 21)",
                                                      " (in 'CCCMGARCH', line 154, column 29 to column 31)",
                                                      " (in 'CCCMGARCH', line 155, column 8 to column 10)",
                                                      " (in 'CCCMGARCH', line 155, column 20 to column 21)",
                                                      " (in 'CCCMGARCH', line 156, column 9 to column 11)",
                                                      " (in 'CCCMGARCH', line 159, column 14 to column 16)",
                                                      " (in 'CCCMGARCH', line 161, column 20 to column 22)",
                                                      " (in 'CCCMGARCH', line 166, column 8 to column 9)",
                                                      " (in 'CCCMGARCH', line 166, column 22 to column 24)",
                                                      " (in 'CCCMGARCH', line 167, column 8 to column 11)",
                                                      " (in 'CCCMGARCH', line 167, column 20 to column 22)",
                                                      " (in 'CCCMGARCH', line 168, column 8 to column 9)",
                                                      " (in 'CCCMGARCH', line 168, column 18 to column 20)",
                                                      " (in 'CCCMGARCH', line 169, column 8 to column 9)",
                                                      " (in 'CCCMGARCH', line 169, column 18 to column 20)",
                                                      " (in 'CCCMGARCH', line 170, column 8 to column 10)",
                                                      " (in 'CCCMGARCH', line 171, column 8 to column 10)",
                                                      " (in 'CCCMGARCH', line 172, column 8 to column 10)",
                                                      " (in 'CCCMGARCH', line 173, column 8 to column 9)",
                                                      " (in 'CCCMGARCH', line 173, column 38 to column 40)",
                                                      " (in 'CCCMGARCH', line 174, column 9 to column 11)",
                                                      " (in 'CCCMGARCH', line 175, column 9 to column 11)",
                                                      " (in 'CCCMGARCH', line 176, column 8 to column 9)",
                                                      " (in 'CCCMGARCH', line 176, column 40 to column 42)",
                                                      " (in 'CCCMGARCH', line 250, column 9 to column 11)",
                                                      " (in 'CCCMGARCH', line 250, column 12 to column 13)",
                                                      " (in 'CCCMGARCH', line 251, column 8 to column 9)",
                                                      " (in 'CCCMGARCH', line 252, column 8 to column 9)",
                                                      " (in 'CCCMGARCH', line 252, column 23 to column 25)",
                                                      " (in 'CCCMGARCH', line 253, column 18 to column 20)",
                                                      " (in 'CCCMGARCH', line 5, column 4 to column 21)",
                                                      " (in 'CCCMGARCH', line 6, column 11 to column 13)",
                                                      " (in 'CCCMGARCH', line 6, column 14 to column 16)",
                                                      " (in 'CCCMGARCH', line 6, column 4 to column 20)",
                                                      " (in 'CCCMGARCH', line 7, column 11 to column 13)",
                                                      " (in 'CCCMGARCH', line 7, column 14 to column 16)",
                                                      " (in 'CCCMGARCH', line 7, column 4 to column 20)",
                                                      " (in 'CCCMGARCH', line 8, column 4 to column 46)",
                                                      " (in 'CCCMGARCH', line 9, column 4 to column 15)",
                                                      " (in 'CCCMGARCH', line 10, column 4 to column 13)",
                                                      " (in 'CCCMGARCH', line 4, column 24 to line 11, column 1)",
                                                      " (in 'CCCMGARCH', line 21, column 2 to column 41)",
                                                      " (in 'CCCMGARCH', line 22, column 2 to column 70)",
                                                      " (in 'CCCMGARCH', line 23, column 2 to column 14)",
                                                      " (in 'CCCMGARCH', line 20, column 52 to line 24, column 1)",
                                                      " (in 'CCCMGARCH', line 34, column 2 to column 41)",
                                                      " (in 'CCCMGARCH', line 33, column 43 to line 35, column 1)",
                                                      " (in 'CCCMGARCH', line 44, column 2 to column 32)",
                                                      " (in 'CCCMGARCH', line 45, column 2 to column 20)",
                                                      " (in 'CCCMGARCH', line 46, column 9 to column 11)",
                                                      " (in 'CCCMGARCH', line 46, column 2 to column 22)",
                                                      " (in 'CCCMGARCH', line 47, column 9 to column 11)",
                                                      " (in 'CCCMGARCH', line 47, column 2 to column 17)",
                                                      " (in 'CCCMGARCH', line 49, column 4 to column 35)",
                                                      " (in 'CCCMGARCH', line 50, column 4 to column 29)",
                                                      " (in 'CCCMGARCH', line 51, column 21 to column 37)",
                                                      " (in 'CCCMGARCH', line 51, column 20 to column 38)",
                                                      " (in 'CCCMGARCH', line 51, column 4 to column 38)",
                                                      " (in 'CCCMGARCH', line 48, column 17 to line 52, column 3)",
                                                      " (in 'CCCMGARCH', line 48, column 2 to line 52, column 3)",
                                                      " (in 'CCCMGARCH', line 54, column 2 to column 14)",
                                                      " (in 'CCCMGARCH', line 43, column 40 to line 55, column 1)",
                                                      " (in 'CCCMGARCH', line 64, column 2 to column 37)",
                                                      " (in 'CCCMGARCH', line 65, column 9 to column 11)",
                                                      " (in 'CCCMGARCH', line 65, column 2 to column 17)",
                                                      " (in 'CCCMGARCH', line 67, column 4 to column 56)",
                                                      " (in 'CCCMGARCH', line 66, column 17 to line 68, column 3)",
                                                      " (in 'CCCMGARCH', line 66, column 2 to line 68, column 3)",
                                                      " (in 'CCCMGARCH', line 69, column 2 to column 14)",
                                                      " (in 'CCCMGARCH', line 63, column 64 to line 70, column 1)",
                                                      " (in 'CCCMGARCH', line 84, column 2 to column 29)",
                                                      " (in 'CCCMGARCH', line 85, column 2 to column 39)",
                                                      " (in 'CCCMGARCH', line 86, column 8 to column 9)",
                                                      " (in 'CCCMGARCH', line 86, column 18 to column 20)",
                                                      " (in 'CCCMGARCH', line 86, column 2 to column 26)",
                                                      " (in 'CCCMGARCH', line 88, column 4 to column 59)",
                                                      " (in 'CCCMGARCH', line 87, column 17 to line 89, column 3)",
                                                      " (in 'CCCMGARCH', line 87, column 2 to line 89, column 3)",
                                                      " (in 'CCCMGARCH', line 90, column 2 to column 14)",
                                                      " (in 'CCCMGARCH', line 83, column 73 to line 91, column 1)"};
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, -1>
cov2cor(const T0__& C_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>>;
  const auto& C = to_ref(C_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int dm;
    dm = std::numeric_limits<int>::min();
    
    current_statement__ = 177;
    dm = rows(C);
    current_statement__ = 178;
    validate_non_negative_index("s", "dm", dm);
    current_statement__ = 179;
    validate_non_negative_index("s", "dm", dm);
    Eigen::Matrix<local_scalar_t__, -1, -1> s;
    s = Eigen::Matrix<local_scalar_t__, -1, -1>(dm, dm);
    stan::math::fill(s, DUMMY_VAR__);
    
    current_statement__ = 181;
    validate_non_negative_index("R", "dm", dm);
    current_statement__ = 182;
    validate_non_negative_index("R", "dm", dm);
    Eigen::Matrix<local_scalar_t__, -1, -1> R;
    R = Eigen::Matrix<local_scalar_t__, -1, -1>(dm, dm);
    stan::math::fill(R, DUMMY_VAR__);
    
    current_statement__ = 184;
    assign(s, nil_index_list(),
      diag_matrix(elt_divide(1, stan::math::sqrt(diagonal(C)))),
      "assigning variable s");
    current_statement__ = 185;
    assign(R, nil_index_list(), multiply(multiply(s, C), s),
      "assigning variable R");
    current_statement__ = 186;
    return R;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct cov2cor_functor__ {
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, -1>
operator()(const T0__& C, std::ostream* pstream__)  const 
{
return cov2cor(C, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
a_b_scale_jacobian(const T0__& a, const T1__& b, const T2__& value,
                   std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    local_scalar_t__ invlogit_value;
    invlogit_value = DUMMY_VAR__;
    
    current_statement__ = 188;
    invlogit_value = inv_logit(value);
    local_scalar_t__ out;
    out = DUMMY_VAR__;
    
    current_statement__ = 189;
    out = ((stan::math::log((b - a)) + stan::math::log(invlogit_value)) +
            log1m(invlogit_value));
    current_statement__ = 190;
    return out;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct a_b_scale_jacobian_functor__ {
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
operator()(const T0__& a, const T1__& b, const T2__& value,
           std::ostream* pstream__)  const 
{
return a_b_scale_jacobian(a, b, value, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
a_b_scale(const T0__& a, const T1__& b, const T2__& value,
          std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 192;
    return (a + ((b - a) * inv_logit(value)));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct a_b_scale_functor__ {
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
operator()(const T0__& a, const T1__& b, const T2__& value,
           std::ostream* pstream__)  const 
{
return a_b_scale(a, b, value, pstream__);
}
};
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<T0__>, -1, 1>
upper_limits(const std::vector<Eigen::Matrix<T0__, -1, 1>>& a_h,
             std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int nt;
    nt = std::numeric_limits<int>::min();
    
    current_statement__ = 194;
    nt = num_elements(a_h[(1 - 1)]);
    int Q;
    Q = std::numeric_limits<int>::min();
    
    current_statement__ = 195;
    Q = stan::math::size(a_h);
    current_statement__ = 196;
    validate_non_negative_index("a_h_sums", "nt", nt);
    Eigen::Matrix<local_scalar_t__, -1, 1> a_h_sums;
    a_h_sums = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
    stan::math::fill(a_h_sums, DUMMY_VAR__);
    
    current_statement__ = 198;
    validate_non_negative_index("out", "nt", nt);
    Eigen::Matrix<local_scalar_t__, -1, 1> out;
    out = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
    stan::math::fill(out, DUMMY_VAR__);
    
    current_statement__ = 206;
    for (int k = 1; k <= nt; ++k) {
      current_statement__ = 200;
      assign(a_h_sums, cons_list(index_uni(k), nil_index_list()),
        sum(
          rvalue(a_h,
            cons_list(index_min_max(1, Q),
              cons_list(index_uni(k), nil_index_list())), "a_h")),
        "assigning variable a_h_sums");
      current_statement__ = 201;
      assign(out, cons_list(index_uni(k), nil_index_list()),
        (1 - a_h_sums[(k - 1)]), "assigning variable out");
      current_statement__ = 204;
      if (logical_lte(out[(k - 1)], 0)) {
        current_statement__ = 202;
        assign(out, cons_list(index_uni(k), nil_index_list()), .00001,
          "assigning variable out");
      } }
    current_statement__ = 207;
    return out;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct upper_limits_functor__ {
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<T0__>, -1, 1>
operator()(const std::vector<Eigen::Matrix<T0__, -1, 1>>& a_h,
           std::ostream* pstream__)  const 
{
return upper_limits(a_h, pstream__);
}
};
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, 1>
raw_sum_to_b_h_sum(const T0__& b_h_sum_s_arg__,
                   const T1__& upperLimits_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>>;
  const auto& b_h_sum_s = to_ref(b_h_sum_s_arg__);
  const auto& upperLimits = to_ref(upperLimits_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int nt;
    nt = std::numeric_limits<int>::min();
    
    current_statement__ = 209;
    nt = num_elements(upperLimits);
    current_statement__ = 210;
    validate_non_negative_index("out", "nt", nt);
    Eigen::Matrix<local_scalar_t__, -1, 1> out;
    out = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
    stan::math::fill(out, DUMMY_VAR__);
    
    current_statement__ = 214;
    for (int k = 1; k <= nt; ++k) {
      current_statement__ = 212;
      assign(out, cons_list(index_uni(k), nil_index_list()),
        a_b_scale(0, upperLimits[(k - 1)], b_h_sum_s[(k - 1)], pstream__),
        "assigning variable out");}
    current_statement__ = 215;
    return out;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct raw_sum_to_b_h_sum_functor__ {
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, 1>
operator()(const T0__& b_h_sum_s, const T1__& upperLimits,
           std::ostream* pstream__)  const 
{
return raw_sum_to_b_h_sum(b_h_sum_s, upperLimits, pstream__);
}
};
template <typename T0__, typename T1__>
std::vector<Eigen::Matrix<stan::promote_args_t<T0__,
stan::value_type_t<T1__>>, -1, 1>>
simplex_to_bh(const std::vector<Eigen::Matrix<T0__, -1, 1>>& b_h_simplex,
              const T1__& b_h_sum_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          stan::value_type_t<T1__>>;
  const auto& b_h_sum = to_ref(b_h_sum_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int nt;
    nt = std::numeric_limits<int>::min();
    
    current_statement__ = 217;
    nt = stan::math::size(b_h_simplex);
    int P;
    P = std::numeric_limits<int>::min();
    
    current_statement__ = 218;
    P = num_elements(b_h_simplex[(1 - 1)]);
    current_statement__ = 219;
    validate_non_negative_index("b_h", "P", P);
    current_statement__ = 220;
    validate_non_negative_index("b_h", "nt", nt);
    std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> b_h;
    b_h = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(P, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
    stan::math::fill(b_h, DUMMY_VAR__);
    
    current_statement__ = 224;
    for (int k = 1; k <= nt; ++k) {
      current_statement__ = 222;
      assign(b_h,
        cons_list(index_min_max(1, P),
          cons_list(index_uni(k), nil_index_list())),
        to_array_1d(multiply(b_h_simplex[(k - 1)], b_h_sum[(k - 1)])),
        "assigning variable b_h");}
    current_statement__ = 225;
    return b_h;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct simplex_to_bh_functor__ {
template <typename T0__, typename T1__>
std::vector<Eigen::Matrix<stan::promote_args_t<T0__,
stan::value_type_t<T1__>>, -1, 1>>
operator()(const std::vector<Eigen::Matrix<T0__, -1, 1>>& b_h_simplex,
           const T1__& b_h_sum, std::ostream* pstream__)  const 
{
return simplex_to_bh(b_h_simplex, b_h_sum, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_CCCMGARCH final : public model_base_crtp<model_CCCMGARCH> {
private:
  int T;
  int nt;
  int Q;
  int P;
  std::vector<Eigen::Matrix<double, -1, 1>> rts;
  std::vector<Eigen::Matrix<double, -1, 1>> xC;
  int distribution;
  int meanstructure;
  Eigen::Matrix<double, -1, 1> rts_m;
  Eigen::Matrix<double, -1, 1> rts_sd;
  std::vector<Eigen::Matrix<double, -1, -1>> xC_m;
  int xC_marker;
  double cp;
  int rr_1dim__;
 
public:
  ~model_CCCMGARCH() { }
  
  inline std::string model_name() const final { return "model_CCCMGARCH"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_CCCMGARCH(stan::io::var_context& context__,
                  unsigned int random_seed__ = 0,
                  std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_CCCMGARCH_namespace::model_CCCMGARCH";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 99;
      context__.validate_dims("data initialization","T","int",
          context__.to_vec());
      T = std::numeric_limits<int>::min();
      
      current_statement__ = 99;
      T = context__.vals_i("T")[(1 - 1)];
      current_statement__ = 99;
      current_statement__ = 99;
      check_greater_or_equal(function__, "T", T, 2);
      current_statement__ = 100;
      context__.validate_dims("data initialization","nt","int",
          context__.to_vec());
      nt = std::numeric_limits<int>::min();
      
      current_statement__ = 100;
      nt = context__.vals_i("nt")[(1 - 1)];
      current_statement__ = 100;
      current_statement__ = 100;
      check_greater_or_equal(function__, "nt", nt, 2);
      current_statement__ = 101;
      context__.validate_dims("data initialization","Q","int",
          context__.to_vec());
      Q = std::numeric_limits<int>::min();
      
      current_statement__ = 101;
      Q = context__.vals_i("Q")[(1 - 1)];
      current_statement__ = 101;
      current_statement__ = 101;
      check_greater_or_equal(function__, "Q", Q, 1);
      current_statement__ = 102;
      context__.validate_dims("data initialization","P","int",
          context__.to_vec());
      P = std::numeric_limits<int>::min();
      
      current_statement__ = 102;
      P = context__.vals_i("P")[(1 - 1)];
      current_statement__ = 102;
      current_statement__ = 102;
      check_greater_or_equal(function__, "P", P, 1);
      current_statement__ = 103;
      validate_non_negative_index("rts", "T", T);
      current_statement__ = 104;
      validate_non_negative_index("rts", "nt", nt);
      current_statement__ = 105;
      context__.validate_dims("data initialization","rts","double",
          context__.to_vec(T, nt));
      rts = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(rts, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> rts_flat__;
        current_statement__ = 105;
        assign(rts_flat__, nil_index_list(), context__.vals_r("rts"),
          "assigning variable rts_flat__");
        current_statement__ = 105;
        pos__ = 1;
        current_statement__ = 105;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 105;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 105;
            assign(rts,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              rts_flat__[(pos__ - 1)], "assigning variable rts");
            current_statement__ = 105;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 106;
      validate_non_negative_index("xC", "T", T);
      current_statement__ = 107;
      validate_non_negative_index("xC", "nt", nt);
      current_statement__ = 108;
      context__.validate_dims("data initialization","xC","double",
          context__.to_vec(T, nt));
      xC = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(xC, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xC_flat__;
        current_statement__ = 108;
        assign(xC_flat__, nil_index_list(), context__.vals_r("xC"),
          "assigning variable xC_flat__");
        current_statement__ = 108;
        pos__ = 1;
        current_statement__ = 108;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 108;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 108;
            assign(xC,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              xC_flat__[(pos__ - 1)], "assigning variable xC");
            current_statement__ = 108;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 109;
      context__.validate_dims("data initialization","distribution","int",
          context__.to_vec());
      distribution = std::numeric_limits<int>::min();
      
      current_statement__ = 109;
      distribution = context__.vals_i("distribution")[(1 - 1)];
      current_statement__ = 109;
      current_statement__ = 109;
      check_greater_or_equal(function__, "distribution", distribution, 0);
      current_statement__ = 109;
      current_statement__ = 109;
      check_less_or_equal(function__, "distribution", distribution, 1);
      current_statement__ = 110;
      context__.validate_dims("data initialization","meanstructure","int",
          context__.to_vec());
      meanstructure = std::numeric_limits<int>::min();
      
      current_statement__ = 110;
      meanstructure = context__.vals_i("meanstructure")[(1 - 1)];
      current_statement__ = 110;
      current_statement__ = 110;
      check_greater_or_equal(function__, "meanstructure", meanstructure, 0);
      current_statement__ = 110;
      current_statement__ = 110;
      check_less_or_equal(function__, "meanstructure", meanstructure, 2);
      current_statement__ = 111;
      validate_non_negative_index("rts_m", "nt", nt);
      current_statement__ = 112;
      rts_m = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(rts_m, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 113;
      validate_non_negative_index("rts_sd", "nt", nt);
      current_statement__ = 114;
      rts_sd = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(rts_sd, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 115;
      validate_non_negative_index("xC_m", "T", T);
      current_statement__ = 116;
      validate_non_negative_index("xC_m", "nt", nt);
      current_statement__ = 117;
      validate_non_negative_index("xC_m", "nt", nt);
      current_statement__ = 118;
      xC_m = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(xC_m, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 119;
      xC_marker = std::numeric_limits<int>::min();
      
      current_statement__ = 119;
      xC_marker = 0;
      current_statement__ = 120;
      cp = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 126;
      for (int t = 1; t <= T; ++t) {
        current_statement__ = 121;
        assign(xC_m, cons_list(index_uni(t), nil_index_list()),
          diag_matrix(xC[(t - 1)]), "assigning variable xC_m");
        current_statement__ = 122;
        cp = sum(multiply(transpose(xC_m[(t - 1)]), xC_m[(t - 1)]));
        current_statement__ = 124;
        if (logical_neq(cp, 0)) {
          current_statement__ = 123;
          xC_marker = (xC_marker + 1);
        } }
      current_statement__ = 138;
      if (logical_eq(meanstructure, 0)) {
        current_statement__ = 136;
        for (int i = 1; i <= nt; ++i) {
          current_statement__ = 133;
          assign(rts_m, cons_list(index_uni(i), nil_index_list()),
            mean(
              rvalue(rts,
                cons_list(index_omni(),
                  cons_list(index_uni(i), nil_index_list())), "rts")),
            "assigning variable rts_m");
          current_statement__ = 134;
          assign(rts_sd, cons_list(index_uni(i), nil_index_list()),
            sd(
              rvalue(rts,
                cons_list(index_omni(),
                  cons_list(index_uni(i), nil_index_list())), "rts")),
            "assigning variable rts_sd");}
      } else {
        current_statement__ = 132;
        if ((primitive_value(logical_eq(meanstructure, 1)) ||
            primitive_value(logical_eq(meanstructure, 2)))) {
          current_statement__ = 130;
          for (int i = 1; i <= nt; ++i) {
            current_statement__ = 127;
            assign(rts_m, cons_list(index_uni(i), nil_index_list()),
              rts[(1 - 1)][(i - 1)], "assigning variable rts_m");
            current_statement__ = 128;
            assign(rts_sd, cons_list(index_uni(i), nil_index_list()),
              sd(
                rvalue(rts,
                  cons_list(index_omni(),
                    cons_list(index_uni(i), nil_index_list())), "rts")),
              "assigning variable rts_sd");}
        } 
      }
      current_statement__ = 119;
      current_statement__ = 119;
      check_greater_or_equal(function__, "xC_marker", xC_marker, 0);
      current_statement__ = 120;
      current_statement__ = 120;
      check_greater_or_equal(function__, "cp", cp, 0);
      current_statement__ = 139;
      validate_non_negative_index("phi0", "nt", nt);
      current_statement__ = 140;
      validate_non_negative_index("phi", "nt", nt);
      current_statement__ = 141;
      validate_non_negative_index("phi", "nt", nt);
      current_statement__ = 142;
      validate_non_negative_index("theta", "nt", nt);
      current_statement__ = 143;
      validate_non_negative_index("theta", "nt", nt);
      current_statement__ = 144;
      validate_non_negative_index("beta", "nt", nt);
      current_statement__ = 145;
      validate_non_negative_index("c_h", "nt", nt);
      current_statement__ = 146;
      validate_non_negative_index("a_h_simplex", "nt", nt);
      current_statement__ = 147;
      validate_positive_index("a_h_simplex", "Q", Q);
      current_statement__ = 148;
      validate_non_negative_index("a_h_sum", "nt", nt);
      current_statement__ = 149;
      validate_non_negative_index("b_h_simplex", "nt", nt);
      current_statement__ = 150;
      validate_positive_index("b_h_simplex", "P", P);
      current_statement__ = 151;
      validate_non_negative_index("b_h_sum_s", "nt", nt);
      current_statement__ = 152;
      validate_non_negative_index("R", "nt", nt);
      current_statement__ = 152;
      validate_non_negative_index("R", "nt", nt);
      current_statement__ = 153;
      validate_non_negative_index("D1_init", "nt", nt);
      current_statement__ = 154;
      validate_non_negative_index("H", "T", T);
      current_statement__ = 155;
      validate_non_negative_index("H", "nt", nt);
      current_statement__ = 155;
      validate_non_negative_index("H", "nt", nt);
      current_statement__ = 156;
      rr_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 156;
      rr_1dim__ = (T - 1);
      current_statement__ = 156;
      validate_non_negative_index("rr", "T - 1", rr_1dim__);
      current_statement__ = 157;
      validate_non_negative_index("rr", "nt", nt);
      current_statement__ = 158;
      validate_non_negative_index("mu", "T", T);
      current_statement__ = 159;
      validate_non_negative_index("mu", "nt", nt);
      current_statement__ = 160;
      validate_non_negative_index("D", "T", T);
      current_statement__ = 161;
      validate_non_negative_index("D", "nt", nt);
      current_statement__ = 162;
      validate_non_negative_index("vd", "nt", nt);
      current_statement__ = 163;
      validate_non_negative_index("ma_d", "nt", nt);
      current_statement__ = 164;
      validate_non_negative_index("ar_d", "nt", nt);
      current_statement__ = 165;
      validate_non_negative_index("a_h", "Q", Q);
      current_statement__ = 166;
      validate_non_negative_index("a_h", "nt", nt);
      current_statement__ = 167;
      validate_non_negative_index("UPs", "nt", nt);
      current_statement__ = 168;
      validate_non_negative_index("ULs", "nt", nt);
      current_statement__ = 169;
      validate_non_negative_index("b_h", "P", P);
      current_statement__ = 170;
      validate_non_negative_index("b_h", "nt", nt);
      current_statement__ = 171;
      validate_non_negative_index("rts_out", "nt", nt);
      current_statement__ = 172;
      validate_non_negative_index("rts_out", "T", T);
      current_statement__ = 173;
      validate_non_negative_index("log_lik", "T", T);
      current_statement__ = 174;
      validate_non_negative_index("corH", "T", T);
      current_statement__ = 175;
      validate_non_negative_index("corH", "nt", nt);
      current_statement__ = 175;
      validate_non_negative_index("corH", "nt", nt);
      current_statement__ = 176;
      validate_non_negative_index("c_h_var", "nt", nt);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += nt;
      num_params_r__ += nt * nt;
      num_params_r__ += nt * nt;
      num_params_r__ += nt;
      num_params_r__ += nt;
      num_params_r__ += nt * (Q - 1);
      num_params_r__ += nt;
      num_params_r__ += nt * (P - 1);
      num_params_r__ += nt;
      num_params_r__ += ((nt * (nt - 1)) / 2);
      num_params_r__ += nt;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_CCCMGARCH_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> phi0;
      phi0 = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
      stan::math::fill(phi0, DUMMY_VAR__);
      
      current_statement__ = 1;
      phi0 = in__.vector(nt);
      Eigen::Matrix<local_scalar_t__, -1, -1> phi;
      phi = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(phi, DUMMY_VAR__);
      
      current_statement__ = 2;
      phi = in__.matrix(nt, nt);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 2;
          if (jacobian__) {
            current_statement__ = 2;
            assign(phi,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(phi,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "phi"),
                -1, 1, lp__), "assigning variable phi");
          } else {
            current_statement__ = 2;
            assign(phi,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(phi,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "phi"),
                -1, 1), "assigning variable phi");
          }}}
      Eigen::Matrix<local_scalar_t__, -1, -1> theta;
      theta = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(theta, DUMMY_VAR__);
      
      current_statement__ = 3;
      theta = in__.matrix(nt, nt);
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 3;
          if (jacobian__) {
            current_statement__ = 3;
            assign(theta,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(theta,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "theta"),
                -1, 1, lp__), "assigning variable theta");
          } else {
            current_statement__ = 3;
            assign(theta,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(theta,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "theta"),
                -1, 1), "assigning variable theta");
          }}}
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 4;
      beta = in__.vector(nt);
      Eigen::Matrix<local_scalar_t__, -1, 1> c_h;
      c_h = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
      stan::math::fill(c_h, DUMMY_VAR__);
      
      current_statement__ = 5;
      c_h = in__.vector(nt);
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> a_h_simplex;
      a_h_simplex = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(nt, Eigen::Matrix<local_scalar_t__, -1, 1>(Q));
      stan::math::fill(a_h_simplex, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> a_h_simplex_in__;
      a_h_simplex_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(nt, Eigen::Matrix<local_scalar_t__, -1, 1>(
        (Q - 1)));
      stan::math::fill(a_h_simplex_in__, DUMMY_VAR__);
      
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 6;
        assign(a_h_simplex_in__,
          cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector((Q - 1)), "assigning variable a_h_simplex_in__");}
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 6;
        if (jacobian__) {
          current_statement__ = 6;
          assign(a_h_simplex, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::simplex_constrain(a_h_simplex_in__[(sym1__ - 1)],
              lp__), "assigning variable a_h_simplex");
        } else {
          current_statement__ = 6;
          assign(a_h_simplex, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::simplex_constrain(a_h_simplex_in__[(sym1__ - 1)]),
            "assigning variable a_h_simplex");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> a_h_sum;
      a_h_sum = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
      stan::math::fill(a_h_sum, DUMMY_VAR__);
      
      current_statement__ = 7;
      a_h_sum = in__.vector(nt);
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 7;
        if (jacobian__) {
          current_statement__ = 7;
          assign(a_h_sum, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(a_h_sum[(sym1__ - 1)], 0, 1, lp__),
            "assigning variable a_h_sum");
        } else {
          current_statement__ = 7;
          assign(a_h_sum, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(a_h_sum[(sym1__ - 1)], 0, 1),
            "assigning variable a_h_sum");
        }}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> b_h_simplex;
      b_h_simplex = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(nt, Eigen::Matrix<local_scalar_t__, -1, 1>(P));
      stan::math::fill(b_h_simplex, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> b_h_simplex_in__;
      b_h_simplex_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(nt, Eigen::Matrix<local_scalar_t__, -1, 1>(
        (P - 1)));
      stan::math::fill(b_h_simplex_in__, DUMMY_VAR__);
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 8;
        assign(b_h_simplex_in__,
          cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector((P - 1)), "assigning variable b_h_simplex_in__");}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 8;
        if (jacobian__) {
          current_statement__ = 8;
          assign(b_h_simplex, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::simplex_constrain(b_h_simplex_in__[(sym1__ - 1)],
              lp__), "assigning variable b_h_simplex");
        } else {
          current_statement__ = 8;
          assign(b_h_simplex, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::simplex_constrain(b_h_simplex_in__[(sym1__ - 1)]),
            "assigning variable b_h_simplex");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> b_h_sum_s;
      b_h_sum_s = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
      stan::math::fill(b_h_sum_s, DUMMY_VAR__);
      
      current_statement__ = 9;
      b_h_sum_s = in__.vector(nt);
      Eigen::Matrix<local_scalar_t__, -1, -1> R;
      R = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(R, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> R_in__;
      R_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>(((nt * (nt - 1)) / 2));
      stan::math::fill(R_in__, DUMMY_VAR__);
      
      current_statement__ = 10;
      R_in__ = in__.vector(((nt * (nt - 1)) / 2));
      current_statement__ = 10;
      if (jacobian__) {
        current_statement__ = 10;
        assign(R, nil_index_list(),
          stan::math::corr_matrix_constrain(R_in__, nt, lp__),
          "assigning variable R");
      } else {
        current_statement__ = 10;
        assign(R, nil_index_list(),
          stan::math::corr_matrix_constrain(R_in__, nt),
          "assigning variable R");
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> D1_init;
      D1_init = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
      stan::math::fill(D1_init, DUMMY_VAR__);
      
      current_statement__ = 11;
      D1_init = in__.vector(nt);
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 11;
        if (jacobian__) {
          current_statement__ = 11;
          assign(D1_init, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(D1_init[(sym1__ - 1)], 0, lp__),
            "assigning variable D1_init");
        } else {
          current_statement__ = 11;
          assign(D1_init, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(D1_init[(sym1__ - 1)], 0),
            "assigning variable D1_init");
        }}
      local_scalar_t__ nu;
      nu = DUMMY_VAR__;
      
      current_statement__ = 12;
      nu = in__.scalar();
      current_statement__ = 12;
      if (jacobian__) {
        current_statement__ = 12;
        nu = stan::math::lb_constrain(nu, 2, lp__);
      } else {
        current_statement__ = 12;
        nu = stan::math::lb_constrain(nu, 2);
      }
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> H;
      H = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(T, Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt));
      stan::math::fill(H, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> rr;
      rr = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(rr_1dim__, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
      stan::math::fill(rr, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> mu;
      mu = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
      stan::math::fill(mu, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> D;
      D = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
      stan::math::fill(D, DUMMY_VAR__);
      
      std::vector<local_scalar_t__> vd;
      vd = std::vector<local_scalar_t__>(nt, DUMMY_VAR__);
      
      std::vector<local_scalar_t__> ma_d;
      ma_d = std::vector<local_scalar_t__>(nt, DUMMY_VAR__);
      
      std::vector<local_scalar_t__> ar_d;
      ar_d = std::vector<local_scalar_t__>(nt, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> a_h;
      a_h = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(Q, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
      stan::math::fill(a_h, DUMMY_VAR__);
      
      current_statement__ = 20;
      assign(a_h, nil_index_list(),
        simplex_to_bh(a_h_simplex, a_h_sum, pstream__),
        "assigning variable a_h");
      Eigen::Matrix<local_scalar_t__, -1, 1> UPs;
      UPs = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
      stan::math::fill(UPs, DUMMY_VAR__);
      
      current_statement__ = 21;
      assign(UPs, nil_index_list(), upper_limits(a_h, pstream__),
        "assigning variable UPs");
      Eigen::Matrix<local_scalar_t__, -1, 1> ULs;
      ULs = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
      stan::math::fill(ULs, DUMMY_VAR__);
      
      current_statement__ = 22;
      assign(ULs, nil_index_list(),
        raw_sum_to_b_h_sum(b_h_sum_s, UPs, pstream__),
        "assigning variable ULs");
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> b_h;
      b_h = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(P, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
      stan::math::fill(b_h, DUMMY_VAR__);
      
      current_statement__ = 23;
      assign(b_h, nil_index_list(),
        simplex_to_bh(b_h_simplex, ULs, pstream__), "assigning variable b_h");
      current_statement__ = 24;
      assign(mu,
        cons_list(index_uni(1), cons_list(index_omni(), nil_index_list())),
        phi0, "assigning variable mu");
      current_statement__ = 25;
      assign(D,
        cons_list(index_uni(1), cons_list(index_omni(), nil_index_list())),
        D1_init, "assigning variable D");
      current_statement__ = 26;
      assign(H,
        cons_list(index_uni(1), cons_list(index_omni(), nil_index_list())),
        quad_form_diag(R,
          rvalue(D,
            cons_list(index_uni(1),
              cons_list(index_omni(), nil_index_list())), "D")),
        "assigning variable H");
      current_statement__ = 57;
      for (int t = 2; t <= T; ++t) {
        current_statement__ = 35;
        if (logical_eq(meanstructure, 0)) {
          current_statement__ = 33;
          assign(mu,
            cons_list(index_uni(t),
              cons_list(index_omni(), nil_index_list())), phi0,
            "assigning variable mu");
        } else {
          current_statement__ = 32;
          if (logical_eq(meanstructure, 1)) {
            current_statement__ = 30;
            assign(mu,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())),
              add(
                add(phi0,
                  multiply(phi,
                    rvalue(rts,
                      cons_list(index_uni((t - 1)),
                        cons_list(index_omni(), nil_index_list())), "rts"))),
                multiply(theta,
                  subtract(
                    rvalue(rts,
                      cons_list(index_uni((t - 1)),
                        cons_list(index_omni(), nil_index_list())), "rts"),
                    stan::model::deep_copy(
                      rvalue(mu,
                        cons_list(index_uni((t - 1)),
                          cons_list(index_omni(), nil_index_list())), "mu"))))),
              "assigning variable mu");
          } else {
            current_statement__ = 29;
            if (logical_eq(meanstructure, 2)) {
              current_statement__ = 27;
              assign(mu,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())),
                add(phi0,
                  multiply(phi,
                    rvalue(rts,
                      cons_list(index_uni((t - 1)),
                        cons_list(index_omni(), nil_index_list())), "rts"))),
                "assigning variable mu");
            } 
          }
        }
        current_statement__ = 54;
        for (int d = 1; d <= nt; ++d) {
          current_statement__ = 36;
          assign(vd, cons_list(index_uni(d), nil_index_list()), 0.0,
            "assigning variable vd");
          current_statement__ = 37;
          assign(ma_d, cons_list(index_uni(d), nil_index_list()), 0.0,
            "assigning variable ma_d");
          current_statement__ = 38;
          assign(ar_d, cons_list(index_uni(d), nil_index_list()), 0.0,
            "assigning variable ar_d");
          current_statement__ = 42;
          for (int q = 1; q <= std::min((t - 1), Q); ++q) {
            current_statement__ = 39;
            assign(rr,
              cons_list(index_uni((t - q)),
                cons_list(index_uni(d), nil_index_list())),
              square(
                (rts[((t - q) - 1)][(d - 1)] - mu[((t - q) - 1)][(d - 1)])),
              "assigning variable rr");
            current_statement__ = 40;
            assign(ma_d, cons_list(index_uni(d), nil_index_list()),
              (ma_d[(d - 1)] +
                (a_h[(q - 1)][(d - 1)] * rr[((t - q) - 1)][(d - 1)])),
              "assigning variable ma_d");}
          current_statement__ = 45;
          for (int p = 1; p <= std::min((t - 1), P); ++p) {
            current_statement__ = 43;
            assign(ar_d, cons_list(index_uni(d), nil_index_list()),
              (ar_d[(d - 1)] +
                (b_h[(p - 1)][(d - 1)] * pow(D[((t - p) - 1)][(d - 1)], 2))),
              "assigning variable ar_d");}
          current_statement__ = 51;
          if (logical_gte(xC_marker, 1)) {
            current_statement__ = 49;
            assign(vd, cons_list(index_uni(d), nil_index_list()),
              ((stan::math::exp(
                  (c_h[(d - 1)] + (beta[(d - 1)] * xC[(t - 1)][(d - 1)]))) +
                 ma_d[(d - 1)]) + ar_d[(d - 1)]), "assigning variable vd");
          } else {
            current_statement__ = 48;
            if (logical_eq(xC_marker, 0)) {
              current_statement__ = 46;
              assign(vd, cons_list(index_uni(d), nil_index_list()),
                ((stan::math::exp(c_h[(d - 1)]) + ma_d[(d - 1)]) +
                  ar_d[(d - 1)]), "assigning variable vd");
            } 
          }
          current_statement__ = 52;
          assign(D,
            cons_list(index_uni(t),
              cons_list(index_uni(d), nil_index_list())),
            stan::math::sqrt(vd[(d - 1)]), "assigning variable D");}
        current_statement__ = 55;
        assign(H,
          cons_list(index_uni(t), cons_list(index_omni(), nil_index_list())),
          quad_form_diag(R,
            rvalue(D,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())), "D")),
          "assigning variable H");}
      current_statement__ = 13;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 13;
        current_statement__ = 13;
        check_cov_matrix(function__, "H[sym1__]", H[(sym1__ - 1)]);}
      current_statement__ = 17;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 17;
        current_statement__ = 17;
        check_greater_or_equal(function__, "vd[sym1__]", vd[(sym1__ - 1)], 0);
      }
      current_statement__ = 18;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 18;
        current_statement__ = 18;
        check_greater_or_equal(function__, "ma_d[sym1__]",
                               ma_d[(sym1__ - 1)], 0);}
      current_statement__ = 19;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 19;
        current_statement__ = 19;
        check_greater_or_equal(function__, "ar_d[sym1__]",
                               ar_d[(sym1__ - 1)], 0);}
      current_statement__ = 20;
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        current_statement__ = 20;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 20;
          current_statement__ = 20;
          check_greater_or_equal(function__, "a_h[sym1__, sym2__]",
                                 a_h[(sym1__ - 1)][(sym2__ - 1)], 0);}}
      current_statement__ = 20;
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        current_statement__ = 20;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 20;
          current_statement__ = 20;
          check_less_or_equal(function__, "a_h[sym1__, sym2__]",
                              a_h[(sym1__ - 1)][(sym2__ - 1)], 1);}}
      current_statement__ = 23;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 23;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 23;
          current_statement__ = 23;
          check_greater_or_equal(function__, "b_h[sym1__, sym2__]",
                                 b_h[(sym1__ - 1)][(sym2__ - 1)], 0);}}
      current_statement__ = 23;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 23;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 23;
          current_statement__ = 23;
          check_less_or_equal(function__, "b_h[sym1__, sym2__]",
                              b_h[(sym1__ - 1)][(sym2__ - 1)], 1);}}
      {
        current_statement__ = 79;
        for (int k = 1; k <= nt; ++k) {
          current_statement__ = 76;
          lp_accum__.add(
            uniform_lpdf<propto__>(ULs[(k - 1)], 0, UPs[(k - 1)]));
          current_statement__ = 77;
          lp_accum__.add(
            a_b_scale_jacobian(0, ULs[(k - 1)],
              b_h_sum_s[(k - 1)], pstream__));}
        current_statement__ = 80;
        lp_accum__.add(std_normal_lpdf<propto__>(to_vector(beta)));
        current_statement__ = 81;
        lp_accum__.add(std_normal_lpdf<propto__>(to_vector(c_h)));
        current_statement__ = 83;
        if (logical_eq(distribution, 1)) {
          current_statement__ = 82;
          lp_accum__.add(normal_lpdf<propto__>(nu, nt, 50));
        } 
        current_statement__ = 84;
        lp_accum__.add(lognormal_lpdf<propto__>(to_vector(D1_init), 0, 1));
        current_statement__ = 85;
        lp_accum__.add(std_normal_lpdf<propto__>(to_vector(theta)));
        current_statement__ = 86;
        lp_accum__.add(std_normal_lpdf<propto__>(to_vector(phi)));
        current_statement__ = 87;
        lp_accum__.add(
          multi_normal_lpdf<propto__>(phi0, rts_m, diag_matrix(rts_sd)));
        current_statement__ = 88;
        lp_accum__.add(lkj_corr_lpdf<propto__>(R, 1));
        current_statement__ = 98;
        if (logical_eq(distribution, 0)) {
          current_statement__ = 96;
          for (int t = 1; t <= T; ++t) {
            current_statement__ = 94;
            lp_accum__.add(
              multi_normal_lpdf<propto__>(
                rvalue(rts,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "rts"),
                rvalue(mu,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "mu"),
                rvalue(H,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "H")));}
        } else {
          current_statement__ = 93;
          if (logical_eq(distribution, 1)) {
            current_statement__ = 91;
            for (int t = 1; t <= T; ++t) {
              current_statement__ = 89;
              lp_accum__.add(
                multi_student_t_lpdf<propto__>(
                  rvalue(rts,
                    cons_list(index_uni(t),
                      cons_list(index_omni(), nil_index_list())), "rts"), nu,
                  rvalue(mu,
                    cons_list(index_uni(t),
                      cons_list(index_omni(), nil_index_list())), "mu"),
                  rvalue(H,
                    cons_list(index_uni(t),
                      cons_list(index_omni(), nil_index_list())), "H")));}
          } 
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_CCCMGARCH_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> phi0;
      phi0 = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(phi0, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      phi0 = in__.vector(nt);
      Eigen::Matrix<double, -1, -1> phi;
      phi = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(phi, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      phi = in__.matrix(nt, nt);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 2;
          assign(phi,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_constrain(
              rvalue(phi,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "phi"),
              -1, 1), "assigning variable phi");}}
      Eigen::Matrix<double, -1, -1> theta;
      theta = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(theta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      theta = in__.matrix(nt, nt);
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 3;
          assign(theta,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_constrain(
              rvalue(theta,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "theta"),
              -1, 1), "assigning variable theta");}}
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      beta = in__.vector(nt);
      Eigen::Matrix<double, -1, 1> c_h;
      c_h = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(c_h, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      c_h = in__.vector(nt);
      std::vector<Eigen::Matrix<double, -1, 1>> a_h_simplex;
      a_h_simplex = std::vector<Eigen::Matrix<double, -1, 1>>(nt, Eigen::Matrix<double, -1, 1>(Q));
      stan::math::fill(a_h_simplex, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> a_h_simplex_in__;
      a_h_simplex_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(nt, Eigen::Matrix<local_scalar_t__, -1, 1>(
        (Q - 1)));
      stan::math::fill(a_h_simplex_in__, DUMMY_VAR__);
      
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 6;
        assign(a_h_simplex_in__,
          cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector((Q - 1)), "assigning variable a_h_simplex_in__");}
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 6;
        assign(a_h_simplex, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::simplex_constrain(a_h_simplex_in__[(sym1__ - 1)]),
          "assigning variable a_h_simplex");}
      Eigen::Matrix<double, -1, 1> a_h_sum;
      a_h_sum = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(a_h_sum, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      a_h_sum = in__.vector(nt);
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 7;
        assign(a_h_sum, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_constrain(a_h_sum[(sym1__ - 1)], 0, 1),
          "assigning variable a_h_sum");}
      std::vector<Eigen::Matrix<double, -1, 1>> b_h_simplex;
      b_h_simplex = std::vector<Eigen::Matrix<double, -1, 1>>(nt, Eigen::Matrix<double, -1, 1>(P));
      stan::math::fill(b_h_simplex, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> b_h_simplex_in__;
      b_h_simplex_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(nt, Eigen::Matrix<local_scalar_t__, -1, 1>(
        (P - 1)));
      stan::math::fill(b_h_simplex_in__, DUMMY_VAR__);
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 8;
        assign(b_h_simplex_in__,
          cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector((P - 1)), "assigning variable b_h_simplex_in__");}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 8;
        assign(b_h_simplex, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::simplex_constrain(b_h_simplex_in__[(sym1__ - 1)]),
          "assigning variable b_h_simplex");}
      Eigen::Matrix<double, -1, 1> b_h_sum_s;
      b_h_sum_s = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(b_h_sum_s, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 9;
      b_h_sum_s = in__.vector(nt);
      Eigen::Matrix<double, -1, -1> R;
      R = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(R, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<local_scalar_t__, -1, 1> R_in__;
      R_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>(((nt * (nt - 1)) / 2));
      stan::math::fill(R_in__, DUMMY_VAR__);
      
      current_statement__ = 10;
      R_in__ = in__.vector(((nt * (nt - 1)) / 2));
      current_statement__ = 10;
      assign(R, nil_index_list(),
        stan::math::corr_matrix_constrain(R_in__, nt), "assigning variable R");
      Eigen::Matrix<double, -1, 1> D1_init;
      D1_init = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(D1_init, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 11;
      D1_init = in__.vector(nt);
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 11;
        assign(D1_init, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(D1_init[(sym1__ - 1)], 0),
          "assigning variable D1_init");}
      double nu;
      nu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 12;
      nu = in__.scalar();
      current_statement__ = 12;
      nu = stan::math::lb_constrain(nu, 2);
      std::vector<Eigen::Matrix<double, -1, -1>> H;
      H = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(H, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> rr;
      rr = std::vector<Eigen::Matrix<double, -1, 1>>(rr_1dim__, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(rr, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> mu;
      mu = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> D;
      D = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(D, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> vd;
      vd = std::vector<double>(nt, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> ma_d;
      ma_d = std::vector<double>(nt, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> ar_d;
      ar_d = std::vector<double>(nt, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> a_h;
      a_h = std::vector<Eigen::Matrix<double, -1, 1>>(Q, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(a_h, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> UPs;
      UPs = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(UPs, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> ULs;
      ULs = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(ULs, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> b_h;
      b_h = std::vector<Eigen::Matrix<double, -1, 1>>(P, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(b_h, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(phi0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(phi,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "phi"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(theta,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "theta"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(c_h[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(a_h_simplex[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(a_h_sum[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(b_h_simplex[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(b_h_sum_s[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(R,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "R"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(D1_init[(sym1__ - 1)]);}
      vars__.emplace_back(nu);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 20;
      assign(a_h, nil_index_list(),
        simplex_to_bh(a_h_simplex, a_h_sum, pstream__),
        "assigning variable a_h");
      current_statement__ = 21;
      assign(UPs, nil_index_list(), upper_limits(a_h, pstream__),
        "assigning variable UPs");
      current_statement__ = 22;
      assign(ULs, nil_index_list(),
        raw_sum_to_b_h_sum(b_h_sum_s, UPs, pstream__),
        "assigning variable ULs");
      current_statement__ = 23;
      assign(b_h, nil_index_list(),
        simplex_to_bh(b_h_simplex, ULs, pstream__), "assigning variable b_h");
      current_statement__ = 24;
      assign(mu,
        cons_list(index_uni(1), cons_list(index_omni(), nil_index_list())),
        phi0, "assigning variable mu");
      current_statement__ = 25;
      assign(D,
        cons_list(index_uni(1), cons_list(index_omni(), nil_index_list())),
        D1_init, "assigning variable D");
      current_statement__ = 26;
      assign(H,
        cons_list(index_uni(1), cons_list(index_omni(), nil_index_list())),
        quad_form_diag(R,
          rvalue(D,
            cons_list(index_uni(1),
              cons_list(index_omni(), nil_index_list())), "D")),
        "assigning variable H");
      current_statement__ = 57;
      for (int t = 2; t <= T; ++t) {
        current_statement__ = 35;
        if (logical_eq(meanstructure, 0)) {
          current_statement__ = 33;
          assign(mu,
            cons_list(index_uni(t),
              cons_list(index_omni(), nil_index_list())), phi0,
            "assigning variable mu");
        } else {
          current_statement__ = 32;
          if (logical_eq(meanstructure, 1)) {
            current_statement__ = 30;
            assign(mu,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())),
              add(
                add(phi0,
                  multiply(phi,
                    rvalue(rts,
                      cons_list(index_uni((t - 1)),
                        cons_list(index_omni(), nil_index_list())), "rts"))),
                multiply(theta,
                  subtract(
                    rvalue(rts,
                      cons_list(index_uni((t - 1)),
                        cons_list(index_omni(), nil_index_list())), "rts"),
                    stan::model::deep_copy(
                      rvalue(mu,
                        cons_list(index_uni((t - 1)),
                          cons_list(index_omni(), nil_index_list())), "mu"))))),
              "assigning variable mu");
          } else {
            current_statement__ = 29;
            if (logical_eq(meanstructure, 2)) {
              current_statement__ = 27;
              assign(mu,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())),
                add(phi0,
                  multiply(phi,
                    rvalue(rts,
                      cons_list(index_uni((t - 1)),
                        cons_list(index_omni(), nil_index_list())), "rts"))),
                "assigning variable mu");
            } 
          }
        }
        current_statement__ = 54;
        for (int d = 1; d <= nt; ++d) {
          current_statement__ = 36;
          assign(vd, cons_list(index_uni(d), nil_index_list()), 0.0,
            "assigning variable vd");
          current_statement__ = 37;
          assign(ma_d, cons_list(index_uni(d), nil_index_list()), 0.0,
            "assigning variable ma_d");
          current_statement__ = 38;
          assign(ar_d, cons_list(index_uni(d), nil_index_list()), 0.0,
            "assigning variable ar_d");
          current_statement__ = 42;
          for (int q = 1; q <= std::min((t - 1), Q); ++q) {
            current_statement__ = 39;
            assign(rr,
              cons_list(index_uni((t - q)),
                cons_list(index_uni(d), nil_index_list())),
              square(
                (rts[((t - q) - 1)][(d - 1)] - mu[((t - q) - 1)][(d - 1)])),
              "assigning variable rr");
            current_statement__ = 40;
            assign(ma_d, cons_list(index_uni(d), nil_index_list()),
              (ma_d[(d - 1)] +
                (a_h[(q - 1)][(d - 1)] * rr[((t - q) - 1)][(d - 1)])),
              "assigning variable ma_d");}
          current_statement__ = 45;
          for (int p = 1; p <= std::min((t - 1), P); ++p) {
            current_statement__ = 43;
            assign(ar_d, cons_list(index_uni(d), nil_index_list()),
              (ar_d[(d - 1)] +
                (b_h[(p - 1)][(d - 1)] * pow(D[((t - p) - 1)][(d - 1)], 2))),
              "assigning variable ar_d");}
          current_statement__ = 51;
          if (logical_gte(xC_marker, 1)) {
            current_statement__ = 49;
            assign(vd, cons_list(index_uni(d), nil_index_list()),
              ((stan::math::exp(
                  (c_h[(d - 1)] + (beta[(d - 1)] * xC[(t - 1)][(d - 1)]))) +
                 ma_d[(d - 1)]) + ar_d[(d - 1)]), "assigning variable vd");
          } else {
            current_statement__ = 48;
            if (logical_eq(xC_marker, 0)) {
              current_statement__ = 46;
              assign(vd, cons_list(index_uni(d), nil_index_list()),
                ((stan::math::exp(c_h[(d - 1)]) + ma_d[(d - 1)]) +
                  ar_d[(d - 1)]), "assigning variable vd");
            } 
          }
          current_statement__ = 52;
          assign(D,
            cons_list(index_uni(t),
              cons_list(index_uni(d), nil_index_list())),
            stan::math::sqrt(vd[(d - 1)]), "assigning variable D");}
        current_statement__ = 55;
        assign(H,
          cons_list(index_uni(t), cons_list(index_omni(), nil_index_list())),
          quad_form_diag(R,
            rvalue(D,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())), "D")),
          "assigning variable H");}
      current_statement__ = 13;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 13;
        current_statement__ = 13;
        check_cov_matrix(function__, "H[sym1__]", H[(sym1__ - 1)]);}
      current_statement__ = 17;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 17;
        current_statement__ = 17;
        check_greater_or_equal(function__, "vd[sym1__]", vd[(sym1__ - 1)], 0);
      }
      current_statement__ = 18;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 18;
        current_statement__ = 18;
        check_greater_or_equal(function__, "ma_d[sym1__]",
                               ma_d[(sym1__ - 1)], 0);}
      current_statement__ = 19;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 19;
        current_statement__ = 19;
        check_greater_or_equal(function__, "ar_d[sym1__]",
                               ar_d[(sym1__ - 1)], 0);}
      current_statement__ = 20;
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        current_statement__ = 20;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 20;
          current_statement__ = 20;
          check_greater_or_equal(function__, "a_h[sym1__, sym2__]",
                                 a_h[(sym1__ - 1)][(sym2__ - 1)], 0);}}
      current_statement__ = 20;
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        current_statement__ = 20;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 20;
          current_statement__ = 20;
          check_less_or_equal(function__, "a_h[sym1__, sym2__]",
                              a_h[(sym1__ - 1)][(sym2__ - 1)], 1);}}
      current_statement__ = 23;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 23;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 23;
          current_statement__ = 23;
          check_greater_or_equal(function__, "b_h[sym1__, sym2__]",
                                 b_h[(sym1__ - 1)][(sym2__ - 1)], 0);}}
      current_statement__ = 23;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 23;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 23;
          current_statement__ = 23;
          check_less_or_equal(function__, "b_h[sym1__, sym2__]",
                              b_h[(sym1__ - 1)][(sym2__ - 1)], 1);}}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
              vars__.emplace_back(
                rvalue(H,
                  cons_list(index_uni(sym3__),
                    cons_list(index_uni(sym2__),
                      cons_list(index_uni(sym1__), nil_index_list()))), "H"));
            }}}
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= rr_1dim__; ++sym2__) {
            vars__.emplace_back(rr[(sym2__ - 1)][(sym1__ - 1)]);}}
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            vars__.emplace_back(mu[(sym2__ - 1)][(sym1__ - 1)]);}}
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            vars__.emplace_back(D[(sym2__ - 1)][(sym1__ - 1)]);}}
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          vars__.emplace_back(vd[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          vars__.emplace_back(ma_d[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          vars__.emplace_back(ar_d[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= Q; ++sym2__) {
            vars__.emplace_back(a_h[(sym2__ - 1)][(sym1__ - 1)]);}}
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          vars__.emplace_back(UPs[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          vars__.emplace_back(ULs[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            vars__.emplace_back(b_h[(sym2__ - 1)][(sym1__ - 1)]);}}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, -1> rts_out;
      rts_out = Eigen::Matrix<double, -1, -1>(nt, T);
      stan::math::fill(rts_out, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> log_lik;
      log_lik = std::vector<double>(T, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, -1>> corH;
      corH = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(corH, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> c_h_var;
      c_h_var = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(c_h_var, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 61;
      assign(c_h_var, nil_index_list(), stan::math::exp(c_h),
        "assigning variable c_h_var");
      current_statement__ = 75;
      if (logical_eq(distribution, 0)) {
        current_statement__ = 73;
        for (int t = 1; t <= T; ++t) {
          current_statement__ = 69;
          assign(rts_out,
            cons_list(index_omni(),
              cons_list(index_uni(t), nil_index_list())),
            multi_normal_rng(
              rvalue(mu,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "mu"),
              rvalue(H,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "H"),
              base_rng__), "assigning variable rts_out");
          current_statement__ = 70;
          assign(corH,
            cons_list(index_uni(t),
              cons_list(index_omni(), nil_index_list())),
            cov2cor(
              rvalue(H,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "H"), pstream__),
            "assigning variable corH");
          current_statement__ = 71;
          assign(log_lik, cons_list(index_uni(t), nil_index_list()),
            multi_normal_lpdf<false>(
              rvalue(rts,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "rts"),
              rvalue(mu,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "mu"),
              rvalue(H,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "H")),
            "assigning variable log_lik");}
      } else {
        current_statement__ = 68;
        if (logical_eq(distribution, 1)) {
          current_statement__ = 66;
          for (int t = 1; t <= T; ++t) {
            current_statement__ = 62;
            assign(rts_out,
              cons_list(index_omni(),
                cons_list(index_uni(t), nil_index_list())),
              multi_student_t_rng(nu,
                rvalue(mu,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "mu"),
                rvalue(H,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "H"),
                base_rng__), "assigning variable rts_out");
            current_statement__ = 63;
            assign(corH,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())),
              cov2cor(
                rvalue(H,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "H"), pstream__),
              "assigning variable corH");
            current_statement__ = 64;
            assign(log_lik, cons_list(index_uni(t), nil_index_list()),
              multi_student_t_lpdf<false>(
                rvalue(rts,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "rts"), nu,
                rvalue(mu,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "mu"),
                rvalue(H,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "H")),
              "assigning variable log_lik");}
        } 
      }
      current_statement__ = 60;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 60;
        current_statement__ = 60;
        check_corr_matrix(function__, "corH[sym1__]", corH[(sym1__ - 1)]);}
      current_statement__ = 61;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 61;
        current_statement__ = 61;
        check_greater_or_equal(function__, "c_h_var[sym1__]",
                               c_h_var[(sym1__ - 1)], 0);}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(rts_out,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "rts_out"));
        }}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
            vars__.emplace_back(
              rvalue(corH,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "corH"));
          }}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(c_h_var[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> phi0;
      phi0 = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(phi0, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> phi0_flat__;
        current_statement__ = 1;
        assign(phi0_flat__, nil_index_list(), context__.vals_r("phi0"),
          "assigning variable phi0_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 1;
          assign(phi0, cons_list(index_uni(sym1__), nil_index_list()),
            phi0_flat__[(pos__ - 1)], "assigning variable phi0");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, -1> phi;
      phi = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(phi, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> phi_flat__;
        current_statement__ = 2;
        assign(phi_flat__, nil_index_list(), context__.vals_r("phi"),
          "assigning variable phi_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 2;
            assign(phi,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              phi_flat__[(pos__ - 1)], "assigning variable phi");
            current_statement__ = 2;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, -1> phi_free__;
      phi_free__ = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(phi_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 2;
          assign(phi_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_free(
              rvalue(phi,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "phi"),
              -1, 1), "assigning variable phi_free__");}}
      Eigen::Matrix<double, -1, -1> theta;
      theta = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(theta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> theta_flat__;
        current_statement__ = 3;
        assign(theta_flat__, nil_index_list(), context__.vals_r("theta"),
          "assigning variable theta_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 3;
            assign(theta,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              theta_flat__[(pos__ - 1)], "assigning variable theta");
            current_statement__ = 3;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, -1> theta_free__;
      theta_free__ = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(theta_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 3;
          assign(theta_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_free(
              rvalue(theta,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "theta"),
              -1, 1), "assigning variable theta_free__");}}
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 4;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 4;
          assign(beta, cons_list(index_uni(sym1__), nil_index_list()),
            beta_flat__[(pos__ - 1)], "assigning variable beta");
          current_statement__ = 4;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> c_h;
      c_h = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(c_h, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> c_h_flat__;
        current_statement__ = 5;
        assign(c_h_flat__, nil_index_list(), context__.vals_r("c_h"),
          "assigning variable c_h_flat__");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 5;
          assign(c_h, cons_list(index_uni(sym1__), nil_index_list()),
            c_h_flat__[(pos__ - 1)], "assigning variable c_h");
          current_statement__ = 5;
          pos__ = (pos__ + 1);}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> a_h_simplex;
      a_h_simplex = std::vector<Eigen::Matrix<double, -1, 1>>(nt, Eigen::Matrix<double, -1, 1>(Q));
      stan::math::fill(a_h_simplex, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> a_h_simplex_flat__;
        current_statement__ = 6;
        assign(a_h_simplex_flat__, nil_index_list(),
          context__.vals_r("a_h_simplex"),
          "assigning variable a_h_simplex_flat__");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
          current_statement__ = 6;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 6;
            assign(a_h_simplex,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              a_h_simplex_flat__[(pos__ - 1)],
              "assigning variable a_h_simplex");
            current_statement__ = 6;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> a_h_simplex_free__;
      a_h_simplex_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(nt, Eigen::Matrix<double, -1, 1>(
        (Q - 1)));
      stan::math::fill(a_h_simplex_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 6;
        assign(a_h_simplex_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::simplex_free(a_h_simplex[(sym1__ - 1)]),
          "assigning variable a_h_simplex_free__");}
      Eigen::Matrix<double, -1, 1> a_h_sum;
      a_h_sum = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(a_h_sum, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> a_h_sum_flat__;
        current_statement__ = 7;
        assign(a_h_sum_flat__, nil_index_list(), context__.vals_r("a_h_sum"),
          "assigning variable a_h_sum_flat__");
        current_statement__ = 7;
        pos__ = 1;
        current_statement__ = 7;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 7;
          assign(a_h_sum, cons_list(index_uni(sym1__), nil_index_list()),
            a_h_sum_flat__[(pos__ - 1)], "assigning variable a_h_sum");
          current_statement__ = 7;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> a_h_sum_free__;
      a_h_sum_free__ = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(a_h_sum_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 7;
        assign(a_h_sum_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_free(a_h_sum[(sym1__ - 1)], 0, 1),
          "assigning variable a_h_sum_free__");}
      std::vector<Eigen::Matrix<double, -1, 1>> b_h_simplex;
      b_h_simplex = std::vector<Eigen::Matrix<double, -1, 1>>(nt, Eigen::Matrix<double, -1, 1>(P));
      stan::math::fill(b_h_simplex, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> b_h_simplex_flat__;
        current_statement__ = 8;
        assign(b_h_simplex_flat__, nil_index_list(),
          context__.vals_r("b_h_simplex"),
          "assigning variable b_h_simplex_flat__");
        current_statement__ = 8;
        pos__ = 1;
        current_statement__ = 8;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 8;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 8;
            assign(b_h_simplex,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              b_h_simplex_flat__[(pos__ - 1)],
              "assigning variable b_h_simplex");
            current_statement__ = 8;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> b_h_simplex_free__;
      b_h_simplex_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(nt, Eigen::Matrix<double, -1, 1>(
        (P - 1)));
      stan::math::fill(b_h_simplex_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 8;
        assign(b_h_simplex_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::simplex_free(b_h_simplex[(sym1__ - 1)]),
          "assigning variable b_h_simplex_free__");}
      Eigen::Matrix<double, -1, 1> b_h_sum_s;
      b_h_sum_s = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(b_h_sum_s, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> b_h_sum_s_flat__;
        current_statement__ = 9;
        assign(b_h_sum_s_flat__, nil_index_list(),
          context__.vals_r("b_h_sum_s"),
          "assigning variable b_h_sum_s_flat__");
        current_statement__ = 9;
        pos__ = 1;
        current_statement__ = 9;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 9;
          assign(b_h_sum_s, cons_list(index_uni(sym1__), nil_index_list()),
            b_h_sum_s_flat__[(pos__ - 1)], "assigning variable b_h_sum_s");
          current_statement__ = 9;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, -1> R;
      R = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(R, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> R_flat__;
        current_statement__ = 10;
        assign(R_flat__, nil_index_list(), context__.vals_r("R"),
          "assigning variable R_flat__");
        current_statement__ = 10;
        pos__ = 1;
        current_statement__ = 10;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 10;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 10;
            assign(R,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              R_flat__[(pos__ - 1)], "assigning variable R");
            current_statement__ = 10;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, 1> R_free__;
      R_free__ = Eigen::Matrix<double, -1, 1>(((nt * (nt - 1)) / 2));
      stan::math::fill(R_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 10;
      assign(R_free__, nil_index_list(), stan::math::corr_matrix_free(R),
        "assigning variable R_free__");
      Eigen::Matrix<double, -1, 1> D1_init;
      D1_init = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(D1_init, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> D1_init_flat__;
        current_statement__ = 11;
        assign(D1_init_flat__, nil_index_list(), context__.vals_r("D1_init"),
          "assigning variable D1_init_flat__");
        current_statement__ = 11;
        pos__ = 1;
        current_statement__ = 11;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 11;
          assign(D1_init, cons_list(index_uni(sym1__), nil_index_list()),
            D1_init_flat__[(pos__ - 1)], "assigning variable D1_init");
          current_statement__ = 11;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> D1_init_free__;
      D1_init_free__ = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(D1_init_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 11;
        assign(D1_init_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(D1_init[(sym1__ - 1)], 0),
          "assigning variable D1_init_free__");}
      double nu;
      nu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 12;
      nu = context__.vals_r("nu")[(1 - 1)];
      double nu_free__;
      nu_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 12;
      nu_free__ = stan::math::lb_free(nu, 2);
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(phi0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(phi_free__,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              "phi_free__"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(theta_free__,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              "theta_free__"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(c_h[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= (Q - 1); ++sym2__) {
          vars__.emplace_back(
            a_h_simplex_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(a_h_sum_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= (P - 1); ++sym2__) {
          vars__.emplace_back(
            b_h_simplex_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(b_h_sum_s[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
        vars__.emplace_back(R_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(D1_init_free__[(sym1__ - 1)]);}
      vars__.emplace_back(nu_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("phi0");
    names__.emplace_back("phi");
    names__.emplace_back("theta");
    names__.emplace_back("beta");
    names__.emplace_back("c_h");
    names__.emplace_back("a_h_simplex");
    names__.emplace_back("a_h_sum");
    names__.emplace_back("b_h_simplex");
    names__.emplace_back("b_h_sum_s");
    names__.emplace_back("R");
    names__.emplace_back("D1_init");
    names__.emplace_back("nu");
    names__.emplace_back("H");
    names__.emplace_back("rr");
    names__.emplace_back("mu");
    names__.emplace_back("D");
    names__.emplace_back("vd");
    names__.emplace_back("ma_d");
    names__.emplace_back("ar_d");
    names__.emplace_back("a_h");
    names__.emplace_back("UPs");
    names__.emplace_back("ULs");
    names__.emplace_back("b_h");
    names__.emplace_back("rts_out");
    names__.emplace_back("log_lik");
    names__.emplace_back("corH");
    names__.emplace_back("c_h_var");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(Q)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(P)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(rr_1dim__),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(Q),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(P),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(T)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "phi0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "phi" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "c_h" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "a_h_simplex" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "a_h_sum" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "b_h_simplex" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "b_h_sum_s" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "R" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "D1_init" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "nu");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "H" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= rr_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rr" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "D" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "vd" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ma_d" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ar_d" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= Q; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "a_h" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "UPs" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ULs" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "b_h" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rts_out" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "corH" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "c_h_var" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "phi0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "phi" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "c_h" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= (Q - 1); ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "a_h_simplex" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "a_h_sum" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= (P - 1); ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "b_h_simplex" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "b_h_sum_s" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "R" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "D1_init" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "nu");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "H" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= rr_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rr" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "D" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "vd" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ma_d" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ar_d" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= Q; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "a_h" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "UPs" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "ULs" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "b_h" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rts_out" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "corH" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "c_h_var" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"phi0\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"c_h\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"a_h_simplex\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"vector\",\"length\":" << Q << "}},\"block\":\"parameters\"},{\"name\":\"a_h_sum\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"b_h_simplex\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"vector\",\"length\":" << P << "}},\"block\":\"parameters\"},{\"name\":\"b_h_sum_s\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"R\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"D1_init\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"H\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"transformed_parameters\"},{\"name\":\"rr\",\"type\":{\"name\":\"array\",\"length\":" << rr_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"transformed_parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"transformed_parameters\"},{\"name\":\"D\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"transformed_parameters\"},{\"name\":\"vd\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"ma_d\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"ar_d\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"a_h\",\"type\":{\"name\":\"array\",\"length\":" << Q << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"transformed_parameters\"},{\"name\":\"UPs\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"transformed_parameters\"},{\"name\":\"ULs\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"transformed_parameters\"},{\"name\":\"b_h\",\"type\":{\"name\":\"array\",\"length\":" << P << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"transformed_parameters\"},{\"name\":\"rts_out\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << T << "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"corH\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"c_h_var\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"phi0\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"c_h\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"a_h_simplex\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"vector\",\"length\":" << (Q - 1) << "}},\"block\":\"parameters\"},{\"name\":\"a_h_sum\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"b_h_simplex\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"vector\",\"length\":" << (P - 1) << "}},\"block\":\"parameters\"},{\"name\":\"b_h_sum_s\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"R\",\"type\":{\"name\":\"vector\",\"length\":" << ((nt * (nt - 1)) / 2) << "},\"block\":\"parameters\"},{\"name\":\"D1_init\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"H\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << (nt + ((nt * (nt - 1)) / 2)) << "}},\"block\":\"transformed_parameters\"},{\"name\":\"rr\",\"type\":{\"name\":\"array\",\"length\":" << rr_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"transformed_parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"transformed_parameters\"},{\"name\":\"D\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"transformed_parameters\"},{\"name\":\"vd\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"ma_d\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"ar_d\",\"type\":{\"name\":\"array\",\"length\":" << nt << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"a_h\",\"type\":{\"name\":\"array\",\"length\":" << Q << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"transformed_parameters\"},{\"name\":\"UPs\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"transformed_parameters\"},{\"name\":\"ULs\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"transformed_parameters\"},{\"name\":\"b_h\",\"type\":{\"name\":\"array\",\"length\":" << P << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"transformed_parameters\"},{\"name\":\"rts_out\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << T << "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"corH\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << ((nt * (nt - 1)) / 2) << "}},\"block\":\"generated_quantities\"},{\"name\":\"c_h_var\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_CCCMGARCH_namespace::model_CCCMGARCH;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_CCCMGARCH_namespace::profiles__;
}
#endif
#endif
