% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCDS.R
\name{getCDS}
\alias{getCDS}
\title{Coding Sequence Retrieval}
\usage{
getCDS(
  db = "refseq",
  organism,
  reference = FALSE,
  skip_bacteria = TRUE,
  release = NULL,
  gunzip = FALSE,
  path = file.path("_ncbi_downloads", "CDS"),
  mute_citation = FALSE
)
}
\arguments{
\item{db}{a character string specifying the database from which the genome
shall be retrieved:
\itemize{
\item \code{db = "refseq"}
\item \code{db = "genbank"}
\item \code{db = "ensembl"}
}}

\item{organism}{Organism selector id,
there are three options to characterize an organism:
\itemize{
\item by \code{scientific name}: e.g. \code{organism = "Homo sapiens"}
\item by \code{database specific accession identifier}: e.g. \code{organism = "GCF_000001405.37"} (= NCBI RefSeq identifier for \code{Homo sapiens})
\item by \code{taxonomic identifier from NCBI Taxonomy}: e.g. \code{organism = "9606"} (= taxid of \code{Homo sapiens})
}}

\item{reference}{a logical value indicating whether or not a genome shall be downloaded if it isn't marked in the database as either a reference genome or a representative genome.}

\item{skip_bacteria}{Due to its enormous dataset size (> 700MB as of July 2023),
the bacterial summary file will not be loaded by default anymore. If users
wish to gain insights for the bacterial kingdom they needs to actively specify \code{skip_bacteria = FALSE}. When \code{skip_bacteria = FALSE} is set then the
bacterial summary file will be downloaded.}

\item{release}{a numeric, the database release version of ENSEMBL (\code{db = "ensembl"}). Default is \code{release = NULL} meaning
that the most recent database version is used. \code{release = 75} would for human would give the stable
GRCh37 release in ensembl. Value must be > 46, since ensembl did not structure their data
if the standard format before that.}

\item{gunzip}{a logical, indicating whether or not files should be unzipped.}

\item{path}{a character string specifying the location (a folder)
in which the corresponding CDS file shall be stored.
Default is \code{path} = \code{file.path("_ncbi_downloads","CDS")}.}

\item{mute_citation}{logical, default FALSE, indicating whether citation message should be muted.}
}
\value{
File path to downloaded genome.
}
\description{
Main retrieval function for coding sequences (CDS)
of an organism of interest.
By specifying the scientific name of an organism of interest the
corresponding fasta-file storing the CDS information for the organism
of interest can be downloaded and stored locally. CDS files can be retrieved
from several databases.
}
\details{
Internally this function loads the the overview.txt file from NCBI:

 refseq: ftp://ftp.ncbi.nlm.nih.gov/genomes/refseq/

 genbank: ftp://ftp.ncbi.nlm.nih.gov/genomes/genbank/

and creates a directory relative to file type, if you get fasta genomes it will be
_ncbi_downloads/genomes'.
In case the corresponding fasta file already exists within the
'_ncbi_downloads/genomes' folder and is accessible within the workspace,
no download process will be performed.
For other file types the same rule applies.
}
\examples{
\dontrun{
# download the genome of Arabidopsis thaliana from refseq
# and store the corresponding genome CDS file in '_ncbi_downloads/CDS'
file_path <- getCDS( db       = "refseq",
             organism = "Arabidopsis thaliana",
             path     = file.path("_ncbi_downloads","CDS"))

Ath_CDS <- read_cds(file_path, format = "fasta")

}
}
\seealso{
Other getBio: 
\code{\link{getBio}()},
\code{\link{getCollection}()},
\code{\link{getGFF}()},
\code{\link{getGenome}()},
\code{\link{getProteome}()},
\code{\link{getRNA}()}

Other cds: 
\code{\link{getCDSSet}()},
\code{\link{read_cds}()}
}
\author{
Hajk-Georg Drost
}
\concept{cds}
\concept{getBio}
