% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_bioc_pkg_templates.R
\name{use_bioc_pkg_templates}
\alias{use_bioc_pkg_templates}
\title{Create a biocthis package template R scripts}
\usage{
use_bioc_pkg_templates(open = rlang::is_interactive())
}
\arguments{
\item{open}{Open the newly created file for editing? Happens in RStudio,
if applicable, or via \code{utils::file.edit()} otherwise. This argument has the
same behavior as the \code{open} argument used in \code{usethis} functions.}
}
\value{
This function adds and/or replaces the \code{dev} files in your
R package. That is:
\itemize{
\item \verb{dev/01_create_pkg.R}
\item \verb{dev/02_git_github_setup.R}
\item \verb{dev/03_core_files.R}
\item \verb{dev/04_update.R}
}
}
\description{
This function creates the \code{dev} directory and in it, it creates R script
files that you can follow to create your own Bioconductor-friendly R
package. These R scripts include all the commands you need to get started =)
The commands are designed to be run on the order given, though we also
encourage you to check the latest utility functions in the \code{usethis}
package.
}
\details{
For more details on how this function came to be, check:
\url{https://github.com/r-lib/actions/issues/84}
\url{https://github.com/r-lib/styler/issues/636}
\url{https://github.com/Bioconductor/BiocCheck/issues/57}
\url{https://github.com/Bioconductor/bioconductor.org/issues/54}
\url{https://github.com/r-lib/usethis/issues/1108}
as well as the "biocthis developer notes" vignette
\url{https://lcolladotor.github.io/biocthis/articles/biocthis_dev_notes.html}.
}
\examples{
\dontrun{
## Run this function in your package
use_bioc_pkg_templates()
}

## Create an example package for illustrative purposes.
## Note: you do not need to run this for your own package!
pkgdir <- biocthis_example_pkg()

## Create the biocthis templates
biocthis::use_bioc_pkg_templates()
}
