% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DESeq2_tidiers.R
\name{DESeq2_tidiers}
\alias{DESeq2_tidiers}
\alias{tidy.DESeqDataSet}
\alias{tidy.DESeqResults}
\title{Tidying methods for DESeq2 DESeqDataSet objects}
\usage{
\method{tidy}{DESeqDataSet}(x, colData = FALSE, intercept = FALSE, ...)

\method{tidy}{DESeqResults}(x, ...)
}
\arguments{
\item{x}{DESeqDataSet object}

\item{colData}{whether colData should be included in the tidied output
for those in the DESeqDataSet object. If dataset includes hypothesis test
results, this is ignored}

\item{intercept}{whether to include hypothesis test results from the
(Intercept) term. If dataset does not include hypothesis testing,
this is ignored}

\item{...}{extra arguments (not used)}
}
\value{
If the dataset contains results (p-values and log2 fold changes),
the result is a data frame with the columns
  \item{term}{The contrast being tested, as given to
  \code{results}}
  \item{gene}{gene ID}
  \item{baseMean}{mean abundance level}
  \item{estimate}{estimated log2 fold change}
  \item{stderror}{standard error in log2 fold change estimate}
  \item{statistic}{test statistic}
  \item{p.value}{p-value}
  \item{p.adjusted}{adjusted p-value}

If the dataset does not contain results (\code{DESeq} has
not been run on it), \code{tidy} defaults to tidying the counts in
the dataset:
  \item{gene}{gene ID}
  \item{sample}{sample ID}
  \item{count}{number of reads in this gene in this sample}

If \code{colData = TRUE}, it also merges this with the columns present
in \code{colData(x)}.
}
\description{
This reshapes a DESeq2 expressionset object into a tidy format. If the
dataset contains hypothesis test results (p-values and estimates), this
summarizes one row per gene per possible contrast.
}
\details{
\code{colDat=TRUE} adds covariates from colData to the data frame.
}
\examples{

# From DESeq2 documentation

if (require("DESeq2")) {
    dds <- makeExampleDESeqDataSet(betaSD = 1)

    tidy(dds)
    # With design included
    tidy(dds, colData=TRUE)

    # add a noise confounding effect
    colData(dds)$noise <- rnorm(nrow(colData(dds)))
    design(dds) <- (~ condition + noise)

    # perform differential expression tests
    ddsres <- DESeq(dds, test = "Wald")
    # now results are per-gene, per-term
    tidied <- tidy(ddsres)
    tidied

    if (require("ggplot2")) {
        ggplot(tidied, aes(p.value)) + geom_histogram(binwidth = .05) +
            facet_wrap(~ term, scale = "free_y")
    }
}

}
