% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OTCMethodFunctions.R
\name{Config.OTC}
\alias{Config.OTC}
\title{Extract the testing configuration from group testing results}
\usage{
\method{Config}{OTC}(object, n = 5, top.overall = FALSE, ...)
}
\arguments{
\item{object}{An object of class "OTC", from which the testing
configuration is to be extracted.}

\item{n}{Number of testing configurations.}

\item{top.overall}{logical; if TRUE, best overall testing configurations; if FALSE,
best testing configurations by initial group size}

\item{...}{currently not used.}
}
\value{
A data frame providing the best testing configurations.
}
\description{
Extract the testing configuration from objects of class
"OTC" returned by \code{\link{OTC1}} (\kbd{OTC1})
or \code{\link{OTC2}} (\kbd{OTC2}).
}
\examples{
res1 <- OTC1(algorithm = "D3", p = 0.05, Se = 0.99, Sp = 0.99,
             group.sz = 3:15, obj.fn = "ET")
Config(res1)
}
\author{
Christopher R. Bilder
}
