% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{bqr_list_tables}
\alias{bqr_list_tables}
\title{List BigQuery tables in a dataset}
\usage{
bqr_list_tables(
  projectId = bqr_get_global_project(),
  datasetId = bqr_get_global_dataset(),
  maxResults = -1
)
}
\arguments{
\item{projectId}{The BigQuery project ID}

\item{datasetId}{A datasetId within projectId}

\item{maxResults}{Number of results to return, default \code{-1} returns all results}
}
\value{
dataframe of tables in dataset
}
\description{
List BigQuery tables in a dataset
}
\examples{

\dontrun{
 bqr_list_tables("publicdata", "samples")
}

}
\seealso{
Other Table meta functions: 
\code{\link{Table}()},
\code{\link{bqr_copy_table}()},
\code{\link{bqr_create_table}()},
\code{\link{bqr_delete_table}()},
\code{\link{bqr_patch_table}()},
\code{\link{bqr_table_data}()},
\code{\link{bqr_table_meta}()}
}
\concept{Table meta functions}
