% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastBqDownload.R
\name{bqr_download_query}
\alias{bqr_download_query}
\title{Download data from BigQuery to local folder}
\usage{
bqr_download_query(
  query = NULL,
  target_folder = "data",
  result_file_name = NULL,
  refetch = FALSE,
  useLegacySql = FALSE,
  clean_intermediate_results = TRUE,
  global_project_name = bqr_get_global_project(),
  global_dataset_name = bqr_get_global_dataset(),
  global_bucket_name = googleCloudStorageR::gcs_get_global_bucket()
)
}
\arguments{
\item{query}{The query you want to run.}

\item{target_folder}{Target folder on your local computer.}

\item{result_file_name}{Name of your downloaded file.}

\item{refetch}{Boolean, whether you would like to refetch previously downloaded data.}

\item{useLegacySql}{Boolean, whether to use Legacy SQL. Default is FALSE.}

\item{clean_intermediate_results}{Boolean, whether to keep intermediate files on BigQuery and Google Cloud Storage.}

\item{global_project_name}{BigQuery project name (where you would like to save your file during download).}

\item{global_dataset_name}{BigQuery dataset name (where you would like to save your file during download).}

\item{global_bucket_name}{Google Cloud Storage bucket name (where you would like to save your file during download).}
}
\value{
a data.table.
}
\description{
Requires you to make a bucket at https://console.cloud.google.com/storage/browser
}
\examples{

\dontrun{
library(bigQueryR)

## Auth with a project that has at least BigQuery and Google Cloud Storage scope
bqr_auth()

# Create a bucket at Google Cloud Storage at 
# https://console.cloud.google.com/storage/browser

bqr_download_query(query = "select * from `your_project.your_dataset.your_table`")

}

}
