% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcvusMAR-asyVAR.R
\name{asy_var_vus}
\alias{asy_var_vus}
\title{Asymptotic variance estimation for VUS}
\usage{
asy_var_vus(
  obj_vus,
  diag_test,
  dise_vec,
  veri_stat = NULL,
  rho_est = NULL,
  pi_est = NULL,
  boot = FALSE,
  n_boot = 250,
  parallel = FALSE,
  ncpus = ifelse(parallel, detectCores()/2, NULL)
)
}
\arguments{
\item{obj_vus}{a result of a call to \code{\link{vus_mar}}.}

\item{diag_test}{a numeric vector containing the diagnostic test values. \code{NA} values of \code{diag_test} are not accepted.}

\item{dise_vec}{a n * 3  binary matrix with three columns, corresponding to the three classes of the disease status. In row i, 1 in column j indicates that the i-th subject belongs to class j, with j = 1, 2, 3. A row of \code{NA} values indicates a non-verified subject.}

\item{veri_stat}{a binary vector containing the verification status (1 verified, 0 not verified).}

\item{rho_est}{a result of a call to \code{\link{rho_mlogit}} of \code{\link{rho_knn}} to fit the disease model.}

\item{pi_est}{a result of a call to \code{\link{psglm}} to fit the verification model.}

\item{boot}{a logical value. Default = \code{FALSE}. If set to \code{TRUE}, a bootstrap resampling is employed to estimate the asymptotic variance of the bias-corrected VUS estimators.}

\item{n_boot}{the number of bootstrap replicates, which is used for FULL or KNN estimators, or option \code{boot = TRUE}. The defaut is 250.}

\item{parallel}{a logical value. If \code{TRUE}, a parallel computing is employed in the bootstrap resampling process.}

\item{ncpus}{number of processes to be used in parallel computing. Default is half of available cores.}
}
\value{
\code{asy_var_vus} returns a estimated value of the asymptotic variance.
}
\description{
\code{asy_var_vus} computes the asymptotic variance of full data (FULL) and bias-corrected estimators (i.e. full imputation, mean score imputation, inverse probability weighting, semiparametric efficient and K nearest neighbor) of VUS.
}
\details{
For the FULL estimator, a bootstrap resampling process or Jackknife approach is used to estimate the asymptotic variance, whereas, a bootstrap resampling process is employed to obtain the asymptotic variance of K nearest neighbor estimator.

For the full imputation, mean score imputation, inverse probability weighting and semiparametric efficient estimators of VUS, the asymptotic variances are computed by using the explicit form. Furthermore, a bootstrap procedure is also available, useful in case of small sample sizes.
}
\examples{
data(EOC)

# Preparing the missing disease status
dise_na <- pre_data(EOC$D, EOC$CA125)
dise_vec_na <- dise_na$dise_vec
dise_fact_na <- dise_na$dise

rho_out <- rho_mlogit(dise_fact_na ~ CA125 + CA153 + Age, data = EOC,
                      test = TRUE)
vus_fi <- vus_mar("fi", diag_test = EOC$CA125, dise_vec = dise_vec_na,
                  veri_stat = EOC$V, rho_est = rho_out, ci = FALSE)
var_fi <- asy_var_vus(vus_fi, diag_test = EOC$CA125, dise_vec = dise_vec_na,
                      veri_stat = EOC$V, rho_est = rho_out)



}
\references{
To Duc, K., Chiogna, M. and Adimari, G. (2020)
Nonparametric estimation of ROC surfaces in presence of verification bias.
\emph{REVSTAT-Statistical Journal}. \bold{18}, 5, 697–720.

To Duc, K., Chiogna, M. and Adimari, G. (2016)
Bias-corrected methods for estimating the receiver operating characteristic surface of continuous diagnostic tests.
\emph{Electronic Journal of Statistics}, \bold{10}, 3063-3113.

Guangming, P., Xiping, W. and Wang, Z. (2013)
Non-parameteric statistical inference for $P(X < Y < Z)$.
\emph{Sankhya A}, \bold{75}, 1, 118-138.
}
