% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnec_newdata.R
\name{bnec_newdata}
\alias{bnec_newdata}
\title{bnec_newdata}
\usage{
bnec_newdata(x, resolution = 100, x_range = NA)
}
\arguments{
\item{x}{An object of class \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}} as returned by \code{\link{bnec}}.}

\item{resolution}{A \code{\link[base]{numeric}} vector of length 1 indicating
the number of x values over which to predict values.}

\item{x_range}{A \code{\link[base]{numeric}} vector of length 2 indicating
the range of x values over which to make predictions.}
}
\value{
A \code{\link[base]{data.frame}} to be used in predictions.
}
\description{
Create a dataset for predictions
}
\examples{
\dontrun{
library(bayesnec)
nec4param <- pull_out(manec_example, model = "nec4param")
# Make fine resolution, predict out of range
newdata <- bnec_newdata(nec4param, resolution = 200, x_range = c(0, 4))
nrow(newdata) == 200
all(range(newdata$x) == c(0, 4))
newdata2 <- bnec_newdata(manec_example) # default size
nrow(newdata2) == 100
}

}
