% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{data}
\name{dummyClassifier}
\alias{dummyClassifier}
\title{a method used for the train function in caret}
\format{
An object of class \code{list} of length 13.
}
\usage{
dummyClassifier
}
\description{
a method used for the train function in caret
}
\examples{
# Split the data into training and testing sets
set.seed(2023)
index <- sample(1:nrow(iris), nrow(iris) * 0.8)
train_data <- iris[index,]
test_data <- iris[-index,]

ctrl1 <- caret::trainControl(method = "none")
# Train a dummy classifier with caret
dummy_model <- caret::train(Species ~ ., data = train_data,
                               method = dummyClassifier,
                               strategy = "stratified",
                               trControl = ctrl1)

# Make predictions using the trained dummy classifier
pred_vec <- predict(dummy_model, test_data)

# Evaluate the performance of the dummy classifier
conf_matrix <- caret::confusionMatrix(pred_vec, test_data$Species)
print(conf_matrix)
}
\keyword{datasets}
