#' Infant Health and Development Program Data
#'
#' Infant Health and Development Program (IHDP) is a randomized experiment from
#' 1985 to 1988 which studied the effect of home visits on cognitive test scores
#' for infants.
#'
#' This dataset was first used by Hill (2011), then used by other researchers
#' (Shalit et al. 2017, Louizos et al. 2017).
#'
#' @source
#' Our version of dataset is the dataset used by Louizos et al. (2017).
#' This is the first realization of 10 generated datasets and you can find 
#' other realizations from
#' \url{https://github.com/AMLab-Amsterdam/CEVAE}.
#'
#' @format
#' \describe{
#'   \item{treatment}{Given treatment.}
#'   \item{y_factual}{Observed outcome.}
#'   \item{y_cfactual}{Potential outcome given the opposite treatment.}
#'   \item{mu0}{Control conditional means.}
#'   \item{mu1}{Treated conditional means.}
#'   \item{X1 ~ X6}{Confounders with continuous values.}
#'   \item{X7 ~ X25}{Confounders with binary values.}
#' }
#'
#' @references
#' Hill, J. L. (2011). Bayesian nonparametric modeling for causal inference.
#' *Journal of Computational and Graphical Statistics*, 20(1), 217-240.
#' \doi{10.1198/jcgs.2010.08162}
#'
#' Louizos, C., Shalit, U., Mooij, J. M., Sontag, D., Zemel, R., & Welling, M. (2017).
#' Causal effect inference with deep latent-variable models.
#' *Advances in neural information processing systems*, 30.
#' \doi{10.48550/arXiv.1705.08821}
#' \url{https://github.com/AMLab-Amsterdam/CEVAE}
#'
#' Shalit, U., Johansson, F. D., & Sontag, D. (2017, July).
#' Estimating individual treatment effect: generalization bounds and algorithms.
#' In *International Conference on Machine Learning* (pp. 3076-3085). PMLR.
#' \doi{10.48550/arXiv.1606.03976}
#'
"ihdp"
