% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.r
\name{chat_api}
\alias{chat_api}
\title{Request answer from openai's chat API}
\usage{
chat_api(
  prompt,
  model = NULL,
  config = NULL,
  max_tokens = NULL,
  api_key = NULL,
  ...
)
}
\arguments{
\item{prompt}{character string of the prompt to be completed.}

\item{model}{character string of the model to be used (defaults to
"text-davinci-003").}

\item{config}{a configuration prompt to tell the model how it should behave.}

\item{max_tokens}{The maximum number of tokens to generate in the completion.
2048L is the maximum the models accept.}

\item{api_key}{set the API key. If NULL, looks for the env OPENAI_API_KEY.}

\item{...}{additional parameters to be passed to the API (see [the API
documentation](https://platform.openai.com/docs/api-reference/completions)}
}
\value{
A tibble with available models

a httr2 response object
}
\description{
Request answer from openai's chat API
}
\examples{
\dontrun{
chat_api("Hi, how are you?", config = "answer as a friendly chat bot")
}
}
