% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asciiDescr.r
\name{asciiCoefmat}
\alias{asciiCoefmat}
\title{Translation of the printCoefmat function for ascii}
\usage{
asciiCoefmat(
  x,
  digits = max(3L, getOption("digits") - 2L),
  signif.stars = getOption("show.signif.stars"),
  signif.legend = signif.stars,
  dig.tst = max(1L, min(5L, digits - 1L)),
  cs.ind = 1:k,
  tst.ind = k + 1,
  zap.ind = integer(),
  P.values = NULL,
  has.Pvalue = nc >= 4L && length(cn <- colnames(x)) && substr(cn[nc], 1L, 3L) \%in\%
    c("Pr(", "p-v"),
  eps.Pvalue = .Machine$double.eps,
  na.print = "NA",
  include.rownames = TRUE,
  include.colnames = TRUE,
  header = TRUE,
  ...
)
}
\arguments{
\item{x}{coefficient summary table that is suitable for
printCoefmat}

\item{digits}{minimum number of significant digits to be used for
most numbers.}

\item{signif.stars}{locial; if 'TRUE', P-values are additionally
encoded visually as 'significance stars' in order to help
scanning of long coefficient tables.  It defaults to the
'show.signif.stars' slot of 'options'.}

\item{signif.legend}{logical; if 'TRUE', a legend for the
'significance stars' is printed provided 'signif.stars =
TRUE'.}

\item{dig.tst}{minimum number of significant digits for the test
statistics, see 'tst.ind'.}

\item{cs.ind}{indices (integer) of column numbers which are (like)
*c*oefficients and *s*tandard errors to be formatted together.}

\item{tst.ind}{indices (integer) of column numbers for test
statistics.}

\item{zap.ind}{indices (integer) of column numbers which should be
formatted by zapsmall, i.e., by 'zapping' values close to 0.}

\item{P.values}{logical or 'NULL'; if 'TRUE', the last column of
'x' is formatted by format.pval as P values.  If 'P.values =
NULL', the default, it is set to 'TRUE' only if
'options("show.coef.Pvalue")' is 'TRUE' _and_ 'x' has at least
4 columns _and_ the last column name of 'x' starts with
'"Pr("'.}

\item{has.Pvalue}{logical; if 'TRUE', the last column of 'x'
contains P values; in that case, it is printed if and only if
'P.values' (above) is true.}

\item{eps.Pvalue}{lower threshold for reporting p-values.}

\item{na.print}{a character string to code NA values in printed
output.}

\item{include.rownames}{argument passed to ascii}

\item{include.colnames}{argument passed to ascii}

\item{header}{argument passed to ascii}

\item{...}{other argments passed to ascii}
}
\value{
ascii object. This is character, rather than numeric.
}
\description{
Compared with printCoefmat, this drops the quote and right
arguments, and adds include.rownames, include.colnames and header
default arguments.
}
