% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RweaveAscii.r, R/weaverAscii.r
\name{RweaveTextile}
\alias{RweaveTextile}
\alias{RtangleTextile}
\alias{RweaveTextileOptions}
\alias{RweaveTextileFinish}
\alias{RweaveTextileWritedoc}
\alias{RweaveTextileSetup}
\alias{RweaveTextileRuncode}
\alias{weaverTextile}
\alias{weaverTextileSetup}
\title{A driver to parse textile noweb files with Sweave tool
This driver parses textile files containing R code and replace pieces of
code with their output.}
\usage{
RweaveTextile()

RweaveTextileSetup(
  file,
  syntax,
  output = NULL,
  quiet = FALSE,
  debug = FALSE,
  extension = "txt",
  backend = "textile",
  openSchunk = "\\nbc.. ",
  closeSchunk = "\\n\\np. \\n\\n",
  openSinput = "",
  closeSinput = "",
  openSoutput = "\\n",
  closeSoutput = "",
  indent = "",
  openInclude = "",
  closeInclude = "",
  openFig = "!",
  closeFig = "!",
  ...
)

weaverTextileSetup(
  file,
  syntax,
  output = NULL,
  quiet = FALSE,
  debug = FALSE,
  extension = "txt",
  backend = "textile",
  openSchunk = "\\nbc.. ",
  closeSchunk = "\\n\\np. \\n\\n",
  openSinput = "",
  closeSinput = "",
  openSoutput = "\\n",
  closeSoutput = "",
  indent = "",
  openInclude = "",
  closeInclude = "",
  openFig = "!",
  closeFig = "!",
  use.cache = TRUE,
  ...
)

weaverTextile()
}
\arguments{
\item{file}{file}

\item{syntax}{syntax}

\item{output}{output}

\item{quiet}{quite}

\item{debug}{debug}

\item{...}{...}

\item{use.cache}{use.cache}

\item{stylepath}{stylepath}
}
\value{
None value is returned. From a .Rnw noweb file, the corresponding
  .txt is produced (as eventuals files for graphs).
}
\description{
A driver to parse textile noweb files with Sweave tool
This driver parses textile files containing R code and replace pieces of
code with their output.

RweaveTextileSetup

weaverTextileSetup

weaverTextile
}
\note{
In order to work properly, noweb codes have to be located at the
  beginning of a line (no indentation).

Compare with RweaveLatex driver, RweaveTextile provides one new option :
  \code{format} to choose the format of figure that will be inserted in the
  final document.

In addition, \code{cache} option from \code{weaver}
  package is also available with \code{weaverTextile} driver.

A wrapper for \code{Sweave} can be used, named \code{Textile}.
}
\examples{
  \dontrun{
Textile("file.Rnw")
  }

}
\seealso{
\code{\link[utils]{Sweave}}, \code{\link{Textile}}
}
\author{
David Hajage \email{dhajage@gmail.com}
}
\keyword{IO}
\keyword{file}
\keyword{internal}
