% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.R
\name{sample}
\alias{sample}
\alias{sample,itemMatrix-method}
\alias{sample,associations-method}
\title{Random Samples and Permutations}
\usage{
\S4method{sample}{itemMatrix}(x, size, replace = FALSE, prob = NULL, ...)

\S4method{sample}{associations}(x, size, replace = FALSE, prob = NULL, ...)
}
\arguments{
\item{x}{object to be sampled from (a set of \link{associations} or
\link{transactions}).}

\item{size}{sample size.}

\item{replace}{a logical. Sample with replacement?}

\item{prob}{a numeric vector of probability weights.}

\item{...}{further arguments.}
}
\value{
An object of the same class as \code{x}.
}
\description{
Provides the generic function \code{sample()} and methods to sample from \link{transactions} and
\link{associations}.
}
\examples{
data("Adult")

## sample with replacement
s <- sample(Adult, 500, replace = TRUE)
s
}
\seealso{
Other preprocessing: 
\code{\link{discretize}()},
\code{\link{hierarchy}},
\code{\link{itemCoding}},
\code{\link{merge}()}

Other associations functions: 
\code{\link{abbreviate}()},
\code{\link{associations-class}},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{inspect}()},
\code{\link{is.closed}()},
\code{\link{is.generator}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()},
\code{\link{is.superset}()},
\code{\link{itemsets-class}},
\code{\link{match}()},
\code{\link{rules-class}},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{sort}()},
\code{\link{unique}()}

Other itemMatrix and transactions functions: 
\code{\link{abbreviate}()},
\code{\link{crossTable}()},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{hierarchy}},
\code{\link{image}()},
\code{\link{inspect}()},
\code{\link{is.superset}()},
\code{\link{itemFrequencyPlot}()},
\code{\link{itemFrequency}()},
\code{\link{itemMatrix-class}},
\code{\link{match}()},
\code{\link{merge}()},
\code{\link{random.transactions}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{supportingTransactions}()},
\code{\link{tidLists-class}},
\code{\link{transactions-class}},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{associations functions}
\concept{itemMatrix and transactions functions}
\concept{preprocessing}
\keyword{manip}
