% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arkhe-internal.R
\name{with_seed}
\alias{with_seed}
\title{Evaluate an Expression with a Temporarily Seed}
\usage{
with_seed(expr, seed, ..., envir = parent.frame(), rounding = TRUE)
}
\arguments{
\item{expr}{An \code{\link{expression}} to be evaluated.}

\item{seed}{A single value to be passed to \code{\link[=set.seed]{set.seed()}}.}

\item{...}{Further arguments to be passed to \code{\link[=set.seed]{set.seed()}}.}

\item{envir}{The \link[=environment]{environment} in which \code{expr} should be
evaluated.}

\item{rounding}{A \code{\link{logical}} scalar: should the default discrete uniform
generation method in \R versions prior to 3.6.0 be used? Usefull for unit
testing.}
}
\value{
The results of \code{expr} evaluated.
}
\description{
Evaluate an Expression with a Temporarily Seed
}
\seealso{
\code{\link[=set.seed]{set.seed()}}
}
\keyword{internal}
