% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Q.AR1.R, R/r.AR1.R
\name{Q.AR1}
\alias{Q.AR1}
\alias{r.AR1}
\title{Precision matrix for an AR1 process}
\usage{
Q.AR1(M, sigma, rho, sparse=FALSE, vcov=FALSE)

r.AR1(n, M, sigma, rho)
}
\arguments{
\item{M}{int > 0, number of elements in the AR1 process.}

\item{sigma}{float > 0, pairwise observation standard deviation.}

\item{rho}{float >= 0 & < 1, how correlated pairwise observations are. The
function will still run with values outside of the range [0,1) however the
stability of the simulation results are not gaurunteed.}

\item{sparse}{bool Should the matrix be of class 'dsCMatrix'}

\item{vcov}{bool If the vcov matrix should be returned instead of the
precision matrix.}

\item{n}{int > 0, number of observations to simulate from the GMRF.}
}
\value{
Q.AR1 returns either a precision or variance-covariance function
with a AR1 structure.

r.AR1 retrurns a matrix with n rows which are the n observations of a
Gaussian Markov random field  AR1 process.
}
\description{
Functions for creating precision matricies and observations of
an AR1 process
}
\examples{
require("ggplot2")
# simulate AR1 GMRF
obs <- r.AR1(100, M=30, sigma=1, rho=.98)
# resulting matrix is n x M
dim(obs)
# subtract off the first time point to more easily observe correlation
obs_adj <- obs - obs[,1]
# move objects to a data frame
ar1_df <- data.frame(obs=c(t(obs_adj)), realization=rep(1:100, each=30),
                     time=rep(1:30, 100))
# plot each realization
ggplot(data=ar1_df, aes(time, obs, group=realization, color=realization)) +
    geom_line()

}
