% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aldvmm.init.R
\name{aldvmm.init}
\alias{aldvmm.init}
\title{Creating Initial Values}
\usage{
aldvmm.init(
  X,
  y,
  psi,
  ncmp,
  dist,
  init.method,
  init.est,
  init.lo,
  init.hi,
  optim.method,
  optim.control = list(),
  optim.grad,
  lcoef,
  lcpar,
  lcmp
)
}
\arguments{
\item{X}{a list of design matrices returned by
\ifelse{html}{\code{\link[aldvmm]{aldvmm.mm}}}{\code{aldvmm.mm()}}.
\code{'X'} is of length 2 and includes a design matrix for the model of
component distributions and a design matrix for the model of probabilities
of group membership.}

\item{y}{a numeric vector of observed outcomes from complete observations in
\code{'data'} supplied to
\ifelse{html}{\code{\link[aldvmm]{aldvmm}}}{\code{aldvmm()}}.}

\item{psi}{a numeric vector of minimum and maximum possible utility values
smaller than or equal to 1 (e.g. \code{c(-0.594, 0.883)}). The potential
gap between the maximum value and 1 represents an area with zero density
in the value set from which utilities were obtained. The order of the
minimum and maximum limits in \code{'psi'} does not matter.}

\item{ncmp}{a numeric value of the number of components that are mixed. The
default value is 2. A value of 1 represents a tobit model with a gap
between 1 and the maximum value in \code{'psi'}.}

\item{dist}{an optional character value of the distribution used in the
components. In this release, only the normal distribution is
available, and the default value is set to \code{"normal"}.}

\item{init.method}{an optional character value indicating the method for
obtaining initial values. The following values are available:
\code{"zero"}, \code{"random"}, \code{"constant"} and \code{"sann"}. The
default value is \code{"zero"}.}

\item{init.est}{an optional numeric vector of user-defined initial values.
User-defined initial values override the \code{'init.method'} argument.
Initial values have to follow the same order as parameter estimates in the
return value \code{'coef'}.}

\item{init.lo}{an optional numeric vector of user-defined lower limits for
constrained optimization. When \code{'init.lo'} is not \code{NULL}, the
optimization method \code{"L-BFGS-B"} is used. Lower limits of parameters
have to follow the same order as parameter estimates in the return value
\code{'coef'}.}

\item{init.hi}{an optional numeric vector of user-defined upper limits for
constrained optimization. When \code{'init.hi'} is not \code{NULL}, the
optimization method \code{"L-BFGS-B"} is used. Upper limits of parameters
have to follow the same order as parameter estimates in the return value
\code{'coef'}.}

\item{optim.method}{an optional character value of one of the following
\ifelse{html}{\code{\link[optimx]{optimr}}}{\code{optimx::optimr()}}
methods: \code{"Nelder-Mead"}, \code{"BFGS"}, \code{"CG"},
\code{"L-BFGS-B"}, \code{"nlminb"}, \code{"Rcgmin"}, \code{"Rvmmin"} and
\code{"hjn"}. The default method is \code{"BFGS"}. The method
\code{"L-BFGS-B"} is used when lower and/or upper constraints are set
using \code{'init.lo'} and \code{'init.hi'}. The method \code{"nlm"}
cannot be used in the \code{'aldvmm'} package.}

\item{optim.control}{an optional list of
\ifelse{html}{\code{\link[optimx]{optimr}}}{\code{optimx::optimr()}}
control parameters.}

\item{optim.grad}{an optional logical value indicating if an analytical
gradient should be used in
\ifelse{html}{\code{\link[optimx]{optimr}}}{\code{optimx::optimr()}}
methods that can use this information. The default value is \code{TRUE}.
If \code{'optim.grad'} is set to \code{FALSE}, a finite difference
approximation is used.}

\item{lcoef}{a character vector of length 2 with labels of objects including
regression coefficients of component distributions (default \code{"beta"})
and coefficients of probabilities of component membership (default
\code{"delta"}).}

\item{lcpar}{a character vector with the labels of objects including
constant parameters of component distributions (e.g. the standard
deviation of the normal distribution). The length of \code{'lcpar'}
depends on the distribution supplied to \code{'dist'}.}

\item{lcmp}{a character value representing a stub (default \code{"Comp"})
for labeling objects including regression coefficients in different
components (e.g. "Comp1", "Comp2", ...). This label is also used in
summary tables returned by
\ifelse{html}{\code{\link[aldvmm]{summary.aldvmm}}}{\code{summary.aldvmm()}}.}
}
\value{
\ifelse{html}{\code{\link[aldvmm]{aldvmm.init}}}{\code{aldvmm.init()}}
returns a list with the following objects. \item{\code{est}}{a numeric
vector of initial values of parameters.}
\item{\code{lo}}{a numeric vector of lower limits of parameters.}
\item{\code{hi}}{a numeric vector of upper limits of parameters.}
}
\description{
\ifelse{html}{\code{\link[aldvmm]{aldvmm.init}}}{\code{aldvmm.init()}}
creates initial values for the minimization of the negative log-likelihood
returned by
\ifelse{html}{\code{\link[aldvmm]{aldvmm.ll}}}{\code{aldvmm.ll()}} using
\ifelse{html}{\code{\link[optimx]{optimr}}}{\code{optimx::optimr()}}.
}
\details{
\code{'init.method'} accepts four methods for generating initial
  values: \code{"zero"}, \code{"random"}, \code{"constant"}, \code{"sann"}.
  The method \code{"zero"} sets initial values of all parameters to 0. The
  method \code{"random"} draws random starting values from a standard normal
  distribution.  The method \code{"constant"} estimates a constant-only
  model and uses estimates as initial values for intercepts and constant
  distribution parameters and 0 for all other parameters.  The method
  \code{"sann"} estimates the full model using the simulated annealing
  optimization method and uses all parameter estimates as initial values.
  When user-specified initial values are supplied in \code{'init.est'}, the
  argument \code{'init.method'} is ignored.

  By default, \ifelse{html}{\code{\link[aldvmm]{aldvmm}}}{ \code{aldvmm()}}
  performs unconstrained optimization with upper and lower limits at
  \code{-Inf} and \code{Inf}.  When user-defined lower and upper limits are
  supplied to \code{'init.lo'} and/or \code{'init-hi'}, these default limits
  are replaced with the user-specified values, and the method
  \code{"L-BFGS-B"} is used for box-constrained optimization instead of the
  user defined \code{'optim.method'}.  It is possible to only set either
  maximum or minimum limits.  When initial values supplied to 
  \code{'init.est'} or from default methods lie outside the limits, the 
  in-feasible values will be set to the limits using the function 
  \ifelse{html}{\code{\link[optimx]{bmchk}}}{\code{optimx::bmchk()}}.
}
