#' ZIprop: A package for Zero-Inflated Proportions data (ZIprop)
#' @importFrom stats cor var
#' @import rgenoud
#' @import parallel
#' @importFrom purrr transpose
#' @importFrom data.table :=
#' @importFrom utils capture.output
#' @description
#' We propose a by block-permutation-based methodology (i) to identify factors (discrete or continuous)
#' that are potentially significant, (ii) to define a performance indicator to quantify the percentage
#' of correlation explained by the significant factors subset for Zero-Inflated Proportions data (ZIprop).
#' @references Melina Ribaud, Edith Gabriel, Joseph Hughes, Samuel Soubeyrand.
#' Identifying potential significant factors impacting zero-inflated proportions data.
#' 2020. hal-02936779
#'
#' @docType package
#' @name ZIprop
NULL
#> NULL


