% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_LpS.R
\name{cv.detect.LpS}
\alias{cv.detect.LpS}
\title{Single change point detection for low-rank plus sparse model with cross-validation}
\usage{
cv.detect.LpS(
  data,
  lambda.1.seq = NULL,
  mu.1.seq = NULL,
  alpha_L = 0.25,
  skip = 50,
  nfold = 5
)
}
\arguments{
\item{data}{a n by p datatset matrix}

\item{lambda.1.seq}{a numeric vector, the sequence of tuning parameter for sparse component for the left segment}

\item{mu.1.seq}{a numeric vector, the sequence of tuning parameter for low rank component for the left segment}

\item{alpha_L}{a numeric value, indicates the constraint space of low rank component}

\item{skip}{a positive integer, indicates the number of time points should be skipped close to the boundary}

\item{nfold}{a positive integer, the number of folds for cross validation}
}
\value{
A list object, including
\describe{
  \item{cp}{Estimated change point}
  \item{S_hat1}{Estimated sparse component for the left-handed side}
  \item{S_hat2}{Estimated sparse component for the right-handed side}
  \item{L_hat1}{Estimated low rank component for the left-handed side}
  \item{L_hat2}{Estimated low rank component for the right-handed side}
  \item{sse}{The sum of squared errors for all passed time points}
}
}
\description{
single change point detection with cross-validation
}
\keyword{internal}
