% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS.R
\name{qCTS}
\alias{qCTS}
\title{Quantile function of the classical tempered stable (CTS)}
\usage{
qCTS(
  p,
  alpha = NULL,
  deltap = NULL,
  deltam = NULL,
  lambdap = NULL,
  lambdam = NULL,
  mu = NULL,
  theta = NULL,
  qmin = NULL,
  qmax = NULL,
  ...
)
}
\arguments{
\item{p}{A numeric vector of probabilities. Each probability must be a real
number >0 and <1.}

\item{alpha}{Stability parameter. A real number between 0 and 2.}

\item{deltap}{Scale parameter for the right tail. A real number > 0.}

\item{deltam}{Scale parameter for the left tail. A real number > 0.}

\item{lambdap}{Tempering parameter for the right tail. A real number > 0.}

\item{lambdam}{Tempering parameter for the left tail. A real number > 0.}

\item{mu}{A location parameter, any real number.}

\item{theta}{Parameters stacked as a vector.}

\item{qmin, qmax}{Limits of the interval. Will be computed if
\code{==NULL}.}

\item{...}{Modify \code{\link[=pTSS]{pTSS()}} and \code{\link[stats:uniroot]{stats::uniroot()}}.}
}
\value{
As \code{p} is a numeric vector, the return value is also a numeric
vector of quantiles.
}
\description{
The quantile function of the classical tempered stable (CTS).
}
\details{
\code{theta} denotes the parameter vector \code{(alpha, deltap, deltam,
lambdap, lambdam, mu)}. Either provide the parameters individually OR
provide \code{theta}.
The function searches for a root between \code{qmin} and \code{qmax} with
\code{uniroot}. Boundaries can either be supplied by the user or a built-in
approach using the stable distribution is used.
}
\examples{
\donttest{
  qCTS(0.5,1.5,1,1,1,1,1)
}

}
\seealso{
See also the \code{\link[=pCTS]{pCTS()}} probability function.
}
