% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS.R
\name{charNTS}
\alias{charNTS}
\title{Characteristic function of the normal tempered stable (NTS) distribution}
\usage{
charNTS(
  t,
  alpha = NULL,
  beta = NULL,
  delta = NULL,
  lambda = NULL,
  mu = NULL,
  theta = NULL
)
}
\arguments{
\item{t}{A vector of real numbers where the CF is evaluated.}

\item{alpha}{Stability parameter. A real number between 0 and 1.}

\item{beta}{Skewness parameter. Any real number.}

\item{delta}{Scale parameter. A real number > 0.}

\item{lambda}{Tempering parameter. A real number > 0.}

\item{mu}{A location parameter, any real number.}

\item{theta}{A vector of all other arguments.}
}
\value{
The CF of the normal tempered stable distribution.
}
\description{
Theoretical characteristic function (CF) of the normal tempered
stable distribution.
See Rachev et al. (2011) for details.
}
\details{
\code{theta} denotes the parameter vector \code{(alpha, beta, delta, lambda,
mu)}. Either provide the parameters individually OR provide \code{theta}.
\deqn{\varphi_{NTS}(t;\theta)=E\left[\mathrm{e}^{\mathrm{i}tZ}\right]= \exp
\left(\mathrm{i}t\mu+\delta\Gamma(-\alpha)\left((\lambda-\mathrm{i}t
\beta+t^2/2)^{\alpha}-\lambda^{\alpha}\right)\right)
}
}
\examples{
x <- seq(-10,10,0.25)
y <- charNTS(x,0.5,1,1,1,0)

}
\references{
Massing, T. (2022), 'Parametric Estimation of Tempered Stable Laws'

Rachev, Svetlozar T. & Kim, Young Shin & Bianchi, Michele L. & Fabozzi,
Frank J. (2011) 'Financial models with Lévy processes and volatility
clustering' \doi{10.1002/9781118268070}
}
