% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Structstrings-DotBracketDataFrame.R
\docType{class}
\name{DotBracketDataFrame}
\alias{DotBracketDataFrame}
\alias{DotBracketDataFrameList}
\alias{DotBracketDataFrame-class}
\alias{DotBracketDFrame-class}
\alias{DotBracketDataFrameList-class}
\alias{DotBracketDFrameList-class}
\alias{SimpleSplitDotBracketDataFrameList-class}
\alias{SimpleSplitDotBracketDFrameList-class}
\alias{CompressedSplitDotBracketDataFrameList-class}
\alias{CompressedSplitDotBracketDFrameList-class}
\alias{DBDF}
\alias{DBDFL}
\alias{SplitDotBracketDataFrameList}
\alias{SDBDFL}
\title{DataFrame for storing base pairing information}
\usage{
DotBracketDataFrame(..., row.names = NULL)

DBDF(...)

DotBracketDataFrameList(...)

DBDFL(...)

SplitDotBracketDataFrameList(..., compress = TRUE, cbindArgs = FALSE)

SDBDFL(..., compress = TRUE, cbindArgs = FALSE)
}
\arguments{
\item{...}{for \code{DotBracketDataFrame} the input vectors and for
\code{DotBracketDataFrameList} the \code{DataFrame} or the 
\code{DotBracketDataFrame} objects.}

\item{row.names}{See \code{\link[S4Vectors:DataFrame-class]{DataFrame}}}

\item{compress}{If \code{compress = TRUE}, returns a 
\code{CompressedSplitDotBracketDataFrameList} else returns a 
\code{SimpleSplitDotBracketDataFrameList}.}

\item{cbindArgs}{If \code{cbindArgs = FALSE}, the ... arguments are coerced 
to \code{DotBracketDataFrame} objects and concatenated to form the result. If
\code{cbindArgs = TRUE}, the arguments are combined as columns. The arguments
must then be the same length, with each element of an argument mapping to an 
element in the result.}
}
\value{
a \code{DotBracketDataFrame*} object.
}
\description{
The \code{DotBracketDataFrame} and \code{DotBracketDFrame} object is derived 
from the \code{\link[S4Vectors:DataFrame-class]{DataFrame}} and 
\code{\link[S4Vectors:DataFrame-class]{DFrame}} classes. 
\code{DotBracketDataFrame} implents the concept and can be used to implement
other backends than the in-memory one as done by \code{DotBracketDFrame}. 

The \code{DotBracketDataFrameList} is implemented analogous, which is also
available as \code{CompressedSplitDotBracketDataFrameList}. Since the names
are quite long, the following short cut functions are available for object
creation: \code{DBDF}, \code{DBDFL} and \code{SDBDFL}.

The \code{DotBracketDataFrame} can only contain 5 columns, which are named
\code{pos}, \code{forward}, \code{reverse}, \code{character} and \code{base}.
The last two columns are optional. The type of the first three has to be
\code{integer}, whereas the fourth is a \code{character} and fifth is a 
\code{XStringSet} column.

Upon creation and modification, the validity of the contained base pairing 
information is checked. If the information is not correct, an error is 
thrown.
}
\examples{
# Manual creation
df <- DataFrame(pos = c(1,2,3,4,5,6),
                forward = c(6,5,0,0,2,1),
                reverse = c(1,2,0,0,5,6))
# Either works
dbdf <- as(df,"DotBracketDataFrame")
dbdf <- DotBracketDataFrame(df)
# With multiple input DataFrames a SplitDotBracketDataFrameList is returned
dbdfl <- DotBracketDataFrame(df,df,df,df)

# Creation from a DotBracketString object is probably more common
data("dbs", package = "Structstrings")
dbdfl <- getBasePairing(dbs)
# Elements are returned as DotBracketDataFrames
dbdfl[[1]]
}
