% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fleish_skurt_check.R
\name{fleish_skurt_check}
\alias{fleish_skurt_check}
\title{Fleishman's Third-Order Transformation Lagrangean Constraints for Lower Boundary of Standardized Kurtosis in Asymmetric Distributions}
\usage{
fleish_skurt_check(c, a)
}
\arguments{
\item{c}{a vector of constants c1, c3, lambda}

\item{a}{skew value}
}
\value{
A list with components:

\eqn{dF(c1, c3, \lambda)/d\lambda = \gamma_{1} - g(c1, c3)}

\eqn{dF(c1, c3, \lambda)/dc1 = df(c1, c3)/dc1  - \lambda * dg(c1, c3)/dc1}

\eqn{dF(c1, c3, \lambda)/dc3 = df(c1, c3)/dc3  - \lambda * dg(c1, c3)/dc3}

If the suppled values for c and skew satisfy the Lagrangean expression, it will return 0 for each component.
}
\description{
This function gives the first-order conditions of the Fleishman Transformation Lagrangean expression
    \eqn{F(c1, c3, \lambda) = f(c1, c3) + \lambda * [\gamma_{1} - g(c1, c3)]} used to find the lower kurtosis boundary for a given non-zero skewness
    in \code{\link[SimMultiCorrData]{calc_lower_skurt}} (see Headrick & Sawilowsky, 2002, \doi{10.3102/10769986025004417}).  Here, \eqn{f(c1, c3)} is the equation for
    standardized kurtosis expressed in terms of c1 and c3 only,
    \eqn{\lambda} is the Lagrangean multiplier, \eqn{\gamma_{1}} is skewness, and \eqn{g(c1, c3)} is the equation for skewness expressed
    in terms of c1 and c3 only.  It should be noted that these equations are for \eqn{\gamma_{1} > 0}.  Negative skew values are handled within
    \code{\link[SimMultiCorrData]{calc_lower_skurt}}.  Headrick & Sawilowsky (2002) gave equations for the first-order derivatives \eqn{dF/dc1}
    and \eqn{dF/dc3}.  These were verified and \eqn{dF/d\lambda} was calculated using \code{D} (see \code{\link[stats]{deriv}}).  The second-order conditions to
    verify that the kurtosis is a global minimum are in \code{\link[SimMultiCorrData]{fleish_Hessian}}.
    This function would not ordinarily be called by the user.
}
\references{
Fleishman AI (1978). A Method for Simulating Non-normal Distributions. Psychometrika, 43, 521-532. \doi{10.1007/BF02293811}.

Headrick TC, Sawilowsky SS (2002). Weighted Simplex Procedures for Determining Boundary Points and Constants for the
    Univariate and Multivariate Power Methods. Journal of Educational and Behavioral Statistics, 25, 417-436. \doi{10.3102/10769986025004417}.
}
\seealso{
\code{\link[SimMultiCorrData]{fleish_Hessian}}, \code{\link[SimMultiCorrData]{calc_lower_skurt}}
}
\keyword{Fleishman}
\keyword{boundary,}
\keyword{kurtosis,}
