% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_funs.R
\name{g_inv_bc}
\alias{g_inv_bc}
\title{Inverse Box-Cox transformation}
\usage{
g_inv_bc(s, lambda)
}
\arguments{
\item{s}{argument(s) at which to evaluate the function}

\item{lambda}{Box-Cox parameter}
}
\value{
The evaluation(s) of the inverse Box-Cox function at the given input(s) \code{s}.
}
\description{
Evaluate the inverse Box-Cox transformation. Negative values are permitted.
}
\note{
Special cases include
the identity transformation (\code{lambda = 1}),
the square-root transformation (\code{lambda = 1/2}),
and the log transformation (\code{lambda = 0}).

#' @examples
# (Inverse) log-transformation:
g_inv_bc(1:5, lambda = 0); exp(1:5)

# (Inverse) square-root transformation: note the shift and scaling
g_inv_bc(1:5, lambda = 1/2); (1:5)^2
}
