% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQLDataFrame-class.R
\name{SQLDataFrame}
\alias{SQLDataFrame}
\alias{class:SQLDataFrame}
\alias{SQLDataFrame-class}
\alias{tblData,SQLDataFrame-method}
\alias{tblData}
\alias{dbtable,SQLDataFrame-method}
\alias{dbtable}
\alias{dbkey,SQLDataFrame-method}
\alias{dbkey}
\alias{"dbkey<-"}
\alias{dbkey<-}
\alias{dbkey<-,SQLDataFrame-method}
\alias{dbconcatKey,SQLDataFrame-method}
\alias{dbconcatKey}
\alias{dbnrows,SQLDataFrame-method}
\alias{dbnrows}
\alias{ROWNAMES,SQLDataFrame-method}
\alias{ROWNAMES}
\alias{show,SQLDataFrame-method}
\alias{coerce}
\alias{coerce,SQLDataFrame,data.frame-method}
\alias{as.data.frame,SQLDataFrame-method}
\alias{coerce,SQLDataFrame,DataFrame-method}
\alias{coerce,data.frame,SQLDataFrame-method}
\alias{coerce,DataFrame,SQLDataFrame-method}
\alias{coerce,ANY,SQLDataFrame-method}
\title{SQLDataFrame class}
\usage{
SQLDataFrame(
  conn,
  host,
  user,
  dbname,
  password = NULL,
  billing = character(0),
  type = c("SQLite", "MySQL", "BigQuery"),
  dbtable = character(0),
  dbkey = character(0),
  col.names = NULL
)

\S4method{tblData}{SQLDataFrame}(x)

\S4method{dbtable}{SQLDataFrame}(x)

\S4method{dbkey}{SQLDataFrame}(x)

\S4method{dbkey}{SQLDataFrame}(x) <- value

\S4method{dbconcatKey}{SQLDataFrame}(x)

\S4method{dbnrows}{SQLDataFrame}(x)

\S4method{ROWNAMES}{SQLDataFrame}(x)

\S4method{show}{SQLDataFrame}(object)

\S4method{as.data.frame}{SQLDataFrame}(x, row.names = NULL, optional = NULL, ...)
}
\arguments{
\item{conn}{a valid \code{DBIConnection} from \code{SQLite},
\code{MySQL} or \code{BigQuery}. If provided, arguments of
`user`, `host`, `dbname`, `password` will be ignored.}

\item{host}{host name for MySQL database or project name for
BigQuery.}

\item{user}{user name for SQL database.}

\item{dbname}{database name for SQL connection.}

\item{password}{password for SQL database connection.}

\item{billing}{the Google Cloud project name with authorized
billing information.}

\item{type}{The SQL database type, supports "SQLite", "MySQL" and
"BigQuery".}

\item{dbtable}{A character string for the table name in that
database. If not provided and there is only one table
available, it will be read in by default.}

\item{dbkey}{A character vector for the name of key columns that
could uniquely identify each row of the database table. Will be
ignored for \code{BigQueryConnection}.}

\item{col.names}{A character vector specifying the column names you
want to read into the \code{SQLDataFrame}.}

\item{x}{An \code{SQLDataFrame} object}

\item{value}{The column name to be used as \code{dbkey(x)}}

\item{object}{An \code{SQLDataFrame} object.}

\item{row.names}{\code{NULL} or a character vector giving the row
names for the data frame. Only including this argument for the
\code{as.data.frame} generic. Does not apply to
\code{SQLDataFrame}. See \code{base::as.data.frame} for
details.}

\item{optional}{logical. If \code{TRUE}, setting row names and
converting column names is optional. Only including this
argument for the \code{as.data.frame} generic. Does not apply
to \code{SQLDataFrame}. See \code{base::as.data.frame} for
details.}

\item{...}{additional arguments to be passed.}
}
\value{
A \code{SQLDataFrame} object.
}
\description{
\code{SQLDataFrame} constructor, slot getters, show
    method and coercion methods to \code{DataFrame} and
    \code{data.frame} objects.
}
\examples{

## SQLDataFrame construction
dbname <- system.file("extdata/test.db", package = "SQLDataFrame")
conn <- DBI::dbConnect(DBI::dbDriver("SQLite"), dbname = dbname)
obj <- SQLDataFrame(conn = conn, dbtable = "state",
                    dbkey = "state")
obj1 <- SQLDataFrame(conn = conn, dbtable = "state",
                     dbkey = c("region", "population"))
obj1

### construction from database credentials
obj2 <- SQLDataFrame(dbname = dbname, type = "SQLite",
                     dbtable = "state", dbkey = "state")
all.equal(obj, obj2)  ## [1] TRUE

## slot accessors
dbcon(obj)
dbtable(obj)
dbkey(obj)
dbkey(obj1)

dbconcatKey(obj)
dbconcatKey(obj1)

## slot accessors (for internal use only)
tblData(obj)
dbnrows(obj)

## ROWNAMES
ROWNAMES(obj[sample(10, 5), ])
ROWNAMES(obj1[sample(10, 5), ])

## coercion
as.data.frame(obj)
as(obj, "DataFrame")


## dbkey replacement
dbkey(obj) <- c("region", "population")
obj

## construction from MySQL 
\dontrun{
mysqlConn <- DBI::dbConnect(dbDriver("MySQL"),
                            host = "",
                            user = "",
                            password = "",  ## required if need further
                                            ## aggregation operations such as
                                            ## join, union, rbind, etc. 
                            dbname = "")
sdf <- SQLDataFrame(conn = mysqlConn, dbtable = "", dbkey = "")

## Or pass credentials directly into constructor
objensb <- SQLDataFrame(user = "genome",
                        host = "genome-mysql.soe.ucsc.edu",
                        dbname = "xenTro9",
                        type = "MySQL",
                        dbtable = "xenoRefGene",
                        dbkey = c("name", "txStart"))

}

## construction from BigQuery
\dontrun{
con <- DBI::dbConnect(bigquery(),  ## equivalent dbDriver("bigquery")
                      project = "bigquery-public-data",
                      dataset = "human_variant_annotation",
                      billing = "")  ## your project name that linked to
                                     ## Google Cloud with billing information.
sdf <- SQLDataFrame(conn = con, dbtable = "ncbi_clinvar_hg38_20180701")

## Or pass credentials directly into constructor
sdf1 <- SQLDataFrame(host = "bigquery-public-data",
                     dbname = "human_variant_annotation",
                     billing = "",
                     type = "BigQuery",
                     dbtable = "ncbi_clinvar_hg38_20180701")

}
}
