% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTertiles.R
\name{plotTertiles}
\alias{plotTertiles}
\title{Plot elicted tertiles, median and plausible range for each expert}
\usage{
plotTertiles(
  vals,
  lower,
  upper,
  fs = 12,
  percentages = FALSE,
  expertnames = NULL,
  xl = NULL,
  xlabel = "X"
)
}
\arguments{
\item{vals}{a matrix of elicited tertiles and medians: one column per expert, first 
row is the 33rd percentile, 2nd row is the median, last row is the 66th percentile.}

\item{lower}{a vector of lower plausible limits: one per expert}

\item{upper}{a vector of upper plausible limits: one per expert}

\item{fs}{font size to be used in the plot}

\item{percentages}{set to \code{TRUE} to use percentages on the x-axis}

\item{expertnames}{vector of experts' names}

\item{xl}{vector of limits for x-axis}

\item{xlabel}{x-axis label}
}
\description{
Displays a horizontal bar for each expert, to represent the expert's plausible range.
The coloured sections indicate the experts' tertiles: three intervals judged by the expert
to be equally likely. The experts' medians are shown as dashed lines.
}
\examples{
\dontrun{
l <- c(-5, 0, 5, -10)
u <- c(15, 35, 50, 35)
v <- matrix(c(5, 8, 10,
 10, 15, 20,
 15, 18, 25,
 10, 20, 30),
 3, 4)
plotTertiles(vals = v, lower = l, upper  = u)
}
}
\author{
Jeremy Oakley <j.oakley@sheffield.ac.uk>
}
